/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MarketingListCampaignsRequest;
import com.stackone.stackone_client_java.models.operations.MarketingListCampaignsResponse;
import com.stackone.stackone_client_java.operations.MarketingListCampaigns;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MarketingListCampaignsRequestBuilder {
    private MarketingListCampaignsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MarketingListCampaignsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MarketingListCampaignsRequestBuilder request(MarketingListCampaignsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MarketingListCampaignsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MarketingListCampaignsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MarketingListCampaignsResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListCampaigns.Sync operation = new MarketingListCampaigns.Sync(this.sdkConfiguration, options, this._headers);
        return (MarketingListCampaignsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MarketingListCampaignsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MarketingListCampaigns.Sync operation = new MarketingListCampaigns.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<MarketingListCampaignsRequest, String> iterator = new Paginator<MarketingListCampaignsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MarketingListCampaignsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MarketingListCampaignsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

