/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CompletionScore
 * 
 * <p>The score associated with this completion
 */
public class CompletionScore {
    /**
     * The score percentage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("percentage")
    private JsonNullable<Double> percentage;

    /**
     * The raw string score value
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("raw_value")
    private JsonNullable<String> rawValue;

    @JsonCreator
    public CompletionScore(
            @JsonProperty("percentage") JsonNullable<Double> percentage,
            @JsonProperty("raw_value") JsonNullable<String> rawValue) {
        Utils.checkNotNull(percentage, "percentage");
        Utils.checkNotNull(rawValue, "rawValue");
        this.percentage = percentage;
        this.rawValue = rawValue;
    }
    
    public CompletionScore() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The score percentage
     */
    @JsonIgnore
    public JsonNullable<Double> percentage() {
        return percentage;
    }

    /**
     * The raw string score value
     */
    @JsonIgnore
    public JsonNullable<String> rawValue() {
        return rawValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The score percentage
     */
    public CompletionScore withPercentage(double percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = JsonNullable.of(percentage);
        return this;
    }

    /**
     * The score percentage
     */
    public CompletionScore withPercentage(JsonNullable<Double> percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = percentage;
        return this;
    }

    /**
     * The raw string score value
     */
    public CompletionScore withRawValue(String rawValue) {
        Utils.checkNotNull(rawValue, "rawValue");
        this.rawValue = JsonNullable.of(rawValue);
        return this;
    }

    /**
     * The raw string score value
     */
    public CompletionScore withRawValue(JsonNullable<String> rawValue) {
        Utils.checkNotNull(rawValue, "rawValue");
        this.rawValue = rawValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CompletionScore other = (CompletionScore) o;
        return 
            Utils.enhancedDeepEquals(this.percentage, other.percentage) &&
            Utils.enhancedDeepEquals(this.rawValue, other.rawValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            percentage, rawValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CompletionScore.class,
                "percentage", percentage,
                "rawValue", rawValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<Double> percentage = JsonNullable.undefined();

        private JsonNullable<String> rawValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The score percentage
         */
        public Builder percentage(double percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = JsonNullable.of(percentage);
            return this;
        }

        /**
         * The score percentage
         */
        public Builder percentage(JsonNullable<Double> percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = percentage;
            return this;
        }


        /**
         * The raw string score value
         */
        public Builder rawValue(String rawValue) {
            Utils.checkNotNull(rawValue, "rawValue");
            this.rawValue = JsonNullable.of(rawValue);
            return this;
        }

        /**
         * The raw string score value
         */
        public Builder rawValue(JsonNullable<String> rawValue) {
            Utils.checkNotNull(rawValue, "rawValue");
            this.rawValue = rawValue;
            return this;
        }

        public CompletionScore build() {

            return new CompletionScore(
                percentage, rawValue);
        }

    }
}
