/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneProxyRequestRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneProxyRequestResponse;
import com.stackone.stackone_client_java.operations.StackoneProxyRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Routing API requests through StackOne directly to the underlying provider.
 */
public class AsyncProxy {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Proxy syncSDK;

    AsyncProxy(Proxy syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public Proxy sync() {
        return syncSDK;
    }


    /**
     * Proxy Request
     * 
     * @return The async call builder
     */
    public StackoneProxyRequestRequestBuilder proxyRequest() {
        return new StackoneProxyRequestRequestBuilder(sdkConfiguration);
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param proxyRequestBody 
     * @return {@code CompletableFuture<StackoneProxyRequestResponse>} - The async response
     */
    public CompletableFuture<StackoneProxyRequestResponse> proxyRequest(String xAccountId, ProxyRequestBody proxyRequestBody) {
        return proxyRequest(
                xAccountId, Optional.empty(), proxyRequestBody,
                Optional.empty());
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param prefer Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     * @param proxyRequestBody 
     * @param options additional options
     * @return {@code CompletableFuture<StackoneProxyRequestResponse>} - The async response
     */
    public CompletableFuture<StackoneProxyRequestResponse> proxyRequest(
            String xAccountId, Optional<String> prefer,
            ProxyRequestBody proxyRequestBody, Optional<Options> options) {
        StackoneProxyRequestRequest request =
            StackoneProxyRequestRequest
                .builder()
                .xAccountId(xAccountId)
                .prefer(prefer)
                .proxyRequestBody(proxyRequestBody)
                .build();
        AsyncRequestOperation<StackoneProxyRequestRequest, StackoneProxyRequestResponse> operation
              = new StackoneProxyRequest.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
