/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.MessagingCreateConversationRequestDto;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.models.operations.MessagingCreateConversationRequest;
import com.stackone.stackone_client_java.models.operations.MessagingCreateConversationRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingCreateConversationResponse;
import com.stackone.stackone_client_java.models.operations.MessagingDownloadMessagingAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.MessagingDownloadMessagingAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingDownloadMessagingAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.MessagingGetAttachmentRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetAttachmentRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingGetAttachmentResponse;
import com.stackone.stackone_client_java.models.operations.MessagingGetConversationRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetConversationRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingGetConversationResponse;
import com.stackone.stackone_client_java.models.operations.MessagingGetMessageRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetMessageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingGetMessageResponse;
import com.stackone.stackone_client_java.models.operations.MessagingGetUserRequest;
import com.stackone.stackone_client_java.models.operations.MessagingGetUserRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingGetUserResponse;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingListAttachmentsResponse;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationMessagesRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationMessagesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationMessagesResponse;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingListConversationsResponse;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersResponse;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageRequest;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageResponse;
import com.stackone.stackone_client_java.operations.MessagingCreateConversation;
import com.stackone.stackone_client_java.operations.MessagingDownloadMessagingAttachment;
import com.stackone.stackone_client_java.operations.MessagingGetAttachment;
import com.stackone.stackone_client_java.operations.MessagingGetConversation;
import com.stackone.stackone_client_java.operations.MessagingGetMessage;
import com.stackone.stackone_client_java.operations.MessagingGetUser;
import com.stackone.stackone_client_java.operations.MessagingListAttachments;
import com.stackone.stackone_client_java.operations.MessagingListConversationMessages;
import com.stackone.stackone_client_java.operations.MessagingListConversations;
import com.stackone.stackone_client_java.operations.MessagingListUsers;
import com.stackone.stackone_client_java.operations.MessagingSendMessage;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;


public class Messaging {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncMessaging asyncSDK;

    Messaging(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncMessaging(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncMessaging async() {
        return asyncSDK;
    }

    /**
     * List Conversations
     * 
     * @return The call builder
     */
    public MessagingListConversationsRequestBuilder listConversations() {
        return new MessagingListConversationsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Conversations
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListConversationsResponse listConversations(MessagingListConversationsRequest request) {
        return listConversations(request, Optional.empty());
    }

    /**
     * List Conversations
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListConversationsResponse listConversations(MessagingListConversationsRequest request, Optional<Options> options) {
        RequestOperation<MessagingListConversationsRequest, MessagingListConversationsResponse> operation
              = new MessagingListConversations.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create Conversation
     * 
     * @return The call builder
     */
    public MessagingCreateConversationRequestBuilder createConversation() {
        return new MessagingCreateConversationRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Conversation
     * 
     * @param xAccountId The account identifier
     * @param messagingCreateConversationRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingCreateConversationResponse createConversation(String xAccountId, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        return createConversation(xAccountId, Optional.empty(), messagingCreateConversationRequestDto,
            Optional.empty());
    }

    /**
     * Create Conversation
     * 
     * @param xAccountId The account identifier
     * @param prefer Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     * @param messagingCreateConversationRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingCreateConversationResponse createConversation(
            String xAccountId, Optional<String> prefer,
            MessagingCreateConversationRequestDto messagingCreateConversationRequestDto, Optional<Options> options) {
        MessagingCreateConversationRequest request =
            MessagingCreateConversationRequest
                .builder()
                .xAccountId(xAccountId)
                .prefer(prefer)
                .messagingCreateConversationRequestDto(messagingCreateConversationRequestDto)
                .build();
        RequestOperation<MessagingCreateConversationRequest, MessagingCreateConversationResponse> operation
              = new MessagingCreateConversation.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Conversation
     * 
     * @return The call builder
     */
    public MessagingGetConversationRequestBuilder getConversation() {
        return new MessagingGetConversationRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Conversation
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetConversationResponse getConversation(MessagingGetConversationRequest request) {
        return getConversation(request, Optional.empty());
    }

    /**
     * Get Conversation
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetConversationResponse getConversation(MessagingGetConversationRequest request, Optional<Options> options) {
        RequestOperation<MessagingGetConversationRequest, MessagingGetConversationResponse> operation
              = new MessagingGetConversation.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Download Attachment
     * 
     * @return The call builder
     */
    public MessagingDownloadMessagingAttachmentRequestBuilder downloadMessagingAttachment() {
        return new MessagingDownloadMessagingAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Download Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingDownloadMessagingAttachmentResponse downloadMessagingAttachment(MessagingDownloadMessagingAttachmentRequest request) {
        return downloadMessagingAttachment(request, Optional.empty());
    }

    /**
     * Download Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingDownloadMessagingAttachmentResponse downloadMessagingAttachment(MessagingDownloadMessagingAttachmentRequest request, Optional<Options> options) {
        RequestOperation<MessagingDownloadMessagingAttachmentRequest, MessagingDownloadMessagingAttachmentResponse> operation
              = new MessagingDownloadMessagingAttachment.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Attachments
     * 
     * @return The call builder
     */
    public MessagingListAttachmentsRequestBuilder listAttachments() {
        return new MessagingListAttachmentsRequestBuilder(sdkConfiguration);
    }

    /**
     * List Attachments
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListAttachmentsResponse listAttachments(MessagingListAttachmentsRequest request) {
        return listAttachments(request, Optional.empty());
    }

    /**
     * List Attachments
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListAttachmentsResponse listAttachments(MessagingListAttachmentsRequest request, Optional<Options> options) {
        RequestOperation<MessagingListAttachmentsRequest, MessagingListAttachmentsResponse> operation
              = new MessagingListAttachments.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Attachment
     * 
     * @return The call builder
     */
    public MessagingGetAttachmentRequestBuilder getAttachment() {
        return new MessagingGetAttachmentRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetAttachmentResponse getAttachment(MessagingGetAttachmentRequest request) {
        return getAttachment(request, Optional.empty());
    }

    /**
     * Get Attachment
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetAttachmentResponse getAttachment(MessagingGetAttachmentRequest request, Optional<Options> options) {
        RequestOperation<MessagingGetAttachmentRequest, MessagingGetAttachmentResponse> operation
              = new MessagingGetAttachment.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Users
     * 
     * @return The call builder
     */
    public MessagingListUsersRequestBuilder listUsers() {
        return new MessagingListUsersRequestBuilder(sdkConfiguration);
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListUsersResponse listUsers(MessagingListUsersRequest request) {
        return listUsers(request, Optional.empty());
    }

    /**
     * List Users
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListUsersResponse listUsers(MessagingListUsersRequest request, Optional<Options> options) {
        RequestOperation<MessagingListUsersRequest, MessagingListUsersResponse> operation
              = new MessagingListUsers.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get User
     * 
     * @return The call builder
     */
    public MessagingGetUserRequestBuilder getUser() {
        return new MessagingGetUserRequestBuilder(sdkConfiguration);
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetUserResponse getUser(MessagingGetUserRequest request) {
        return getUser(request, Optional.empty());
    }

    /**
     * Get User
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetUserResponse getUser(MessagingGetUserRequest request, Optional<Options> options) {
        RequestOperation<MessagingGetUserRequest, MessagingGetUserResponse> operation
              = new MessagingGetUser.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * List Conversation Messages
     * 
     * @return The call builder
     */
    public MessagingListConversationMessagesRequestBuilder listConversationMessages() {
        return new MessagingListConversationMessagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Conversation Messages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListConversationMessagesResponse listConversationMessages(MessagingListConversationMessagesRequest request) {
        return listConversationMessages(request, Optional.empty());
    }

    /**
     * List Conversation Messages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingListConversationMessagesResponse listConversationMessages(MessagingListConversationMessagesRequest request, Optional<Options> options) {
        RequestOperation<MessagingListConversationMessagesRequest, MessagingListConversationMessagesResponse> operation
              = new MessagingListConversationMessages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Message
     * 
     * @return The call builder
     */
    public MessagingGetMessageRequestBuilder getMessage() {
        return new MessagingGetMessageRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Message
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetMessageResponse getMessage(MessagingGetMessageRequest request) {
        return getMessage(request, Optional.empty());
    }

    /**
     * Get Message
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingGetMessageResponse getMessage(MessagingGetMessageRequest request, Optional<Options> options) {
        RequestOperation<MessagingGetMessageRequest, MessagingGetMessageResponse> operation
              = new MessagingGetMessage.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Send Message
     * 
     * @return The call builder
     */
    public MessagingSendMessageRequestBuilder sendMessage() {
        return new MessagingSendMessageRequestBuilder(sdkConfiguration);
    }

    /**
     * Send Message
     * 
     * @param xAccountId The account identifier
     * @param messagingMessageSendRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingSendMessageResponse sendMessage(String xAccountId, MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        return sendMessage(xAccountId, Optional.empty(), messagingMessageSendRequestDto,
            Optional.empty());
    }

    /**
     * Send Message
     * 
     * @param xAccountId The account identifier
     * @param prefer Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     * @param messagingMessageSendRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public MessagingSendMessageResponse sendMessage(
            String xAccountId, Optional<String> prefer,
            MessagingMessageSendRequestDto messagingMessageSendRequestDto, Optional<Options> options) {
        MessagingSendMessageRequest request =
            MessagingSendMessageRequest
                .builder()
                .xAccountId(xAccountId)
                .prefer(prefer)
                .messagingMessageSendRequestDto(messagingMessageSendRequestDto)
                .build();
        RequestOperation<MessagingSendMessageRequest, MessagingSendMessageResponse> operation
              = new MessagingSendMessage.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
