/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AccountingJournalValue
 * 
 * <p>The journal status
 */
public class AccountingJournalValue {

    public static final AccountingJournalValue DRAFT = new AccountingJournalValue("draft");
    public static final AccountingJournalValue POSTED = new AccountingJournalValue("posted");
    public static final AccountingJournalValue VOID = new AccountingJournalValue("void");
    public static final AccountingJournalValue UNMAPPED_VALUE = new AccountingJournalValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AccountingJournalValue> values = createValuesMap();
    private static final Map<String, AccountingJournalValueEnum> enums = createEnumsMap();

    private final String value;

    private AccountingJournalValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AccountingJournalValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AccountingJournalValue
     */ 
    @JsonCreator
    public static AccountingJournalValue of(String value) {
        synchronized (AccountingJournalValue.class) {
            return values.computeIfAbsent(value, v -> new AccountingJournalValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AccountingJournalValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccountingJournalValue other = (AccountingJournalValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AccountingJournalValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AccountingJournalValue[] values() {
        synchronized (AccountingJournalValue.class) {
            return values.values().toArray(new AccountingJournalValue[] {});
        }
    }

    private static final Map<String, AccountingJournalValue> createValuesMap() {
        Map<String, AccountingJournalValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("posted", POSTED);
        map.put("void", VOID);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingJournalValueEnum> createEnumsMap() {
        Map<String, AccountingJournalValueEnum> map = new HashMap<>();
        map.put("draft", AccountingJournalValueEnum.DRAFT);
        map.put("posted", AccountingJournalValueEnum.POSTED);
        map.put("void", AccountingJournalValueEnum.VOID);
        map.put("unmapped_value", AccountingJournalValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AccountingJournalValueEnum {

        DRAFT("draft"),
        POSTED("posted"),
        VOID("void"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AccountingJournalValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

