/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Optional;


public class ActionSearchResponseDto {

    @JsonProperty("results")
    private List<ActionSearchResultDto> results;

    /**
     * Total number of results returned
     */
    @JsonProperty("total_count")
    private double totalCount;

    /**
     * Original search query
     */
    @JsonProperty("query")
    private String query;

    /**
     * Connector filter applied
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("connector_filter")
    private Optional<String> connectorFilter;

    /**
     * Project filter applied
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("project_filter")
    private Optional<String> projectFilter;

    @JsonCreator
    public ActionSearchResponseDto(
            @JsonProperty("results") List<ActionSearchResultDto> results,
            @JsonProperty("total_count") double totalCount,
            @JsonProperty("query") String query,
            @JsonProperty("connector_filter") Optional<String> connectorFilter,
            @JsonProperty("project_filter") Optional<String> projectFilter) {
        Utils.checkNotNull(results, "results");
        Utils.checkNotNull(totalCount, "totalCount");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.results = results;
        this.totalCount = totalCount;
        this.query = query;
        this.connectorFilter = connectorFilter;
        this.projectFilter = projectFilter;
    }
    
    public ActionSearchResponseDto(
            List<ActionSearchResultDto> results,
            double totalCount,
            String query) {
        this(results, totalCount, query,
            Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public List<ActionSearchResultDto> results() {
        return results;
    }

    /**
     * Total number of results returned
     */
    @JsonIgnore
    public double totalCount() {
        return totalCount;
    }

    /**
     * Original search query
     */
    @JsonIgnore
    public String query() {
        return query;
    }

    /**
     * Connector filter applied
     */
    @JsonIgnore
    public Optional<String> connectorFilter() {
        return connectorFilter;
    }

    /**
     * Project filter applied
     */
    @JsonIgnore
    public Optional<String> projectFilter() {
        return projectFilter;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ActionSearchResponseDto withResults(List<ActionSearchResultDto> results) {
        Utils.checkNotNull(results, "results");
        this.results = results;
        return this;
    }

    /**
     * Total number of results returned
     */
    public ActionSearchResponseDto withTotalCount(double totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    /**
     * Original search query
     */
    public ActionSearchResponseDto withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    /**
     * Connector filter applied
     */
    public ActionSearchResponseDto withConnectorFilter(String connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = Optional.ofNullable(connectorFilter);
        return this;
    }


    /**
     * Connector filter applied
     */
    public ActionSearchResponseDto withConnectorFilter(Optional<String> connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = connectorFilter;
        return this;
    }

    /**
     * Project filter applied
     */
    public ActionSearchResponseDto withProjectFilter(String projectFilter) {
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.projectFilter = Optional.ofNullable(projectFilter);
        return this;
    }


    /**
     * Project filter applied
     */
    public ActionSearchResponseDto withProjectFilter(Optional<String> projectFilter) {
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.projectFilter = projectFilter;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionSearchResponseDto other = (ActionSearchResponseDto) o;
        return 
            Utils.enhancedDeepEquals(this.results, other.results) &&
            Utils.enhancedDeepEquals(this.totalCount, other.totalCount) &&
            Utils.enhancedDeepEquals(this.query, other.query) &&
            Utils.enhancedDeepEquals(this.connectorFilter, other.connectorFilter) &&
            Utils.enhancedDeepEquals(this.projectFilter, other.projectFilter);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            results, totalCount, query,
            connectorFilter, projectFilter);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionSearchResponseDto.class,
                "results", results,
                "totalCount", totalCount,
                "query", query,
                "connectorFilter", connectorFilter,
                "projectFilter", projectFilter);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private List<ActionSearchResultDto> results;

        private Double totalCount;

        private String query;

        private Optional<String> connectorFilter = Optional.empty();

        private Optional<String> projectFilter = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder results(List<ActionSearchResultDto> results) {
            Utils.checkNotNull(results, "results");
            this.results = results;
            return this;
        }


        /**
         * Total number of results returned
         */
        public Builder totalCount(double totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }


        /**
         * Original search query
         */
        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }


        /**
         * Connector filter applied
         */
        public Builder connectorFilter(String connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = Optional.ofNullable(connectorFilter);
            return this;
        }

        /**
         * Connector filter applied
         */
        public Builder connectorFilter(Optional<String> connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = connectorFilter;
            return this;
        }


        /**
         * Project filter applied
         */
        public Builder projectFilter(String projectFilter) {
            Utils.checkNotNull(projectFilter, "projectFilter");
            this.projectFilter = Optional.ofNullable(projectFilter);
            return this;
        }

        /**
         * Project filter applied
         */
        public Builder projectFilter(Optional<String> projectFilter) {
            Utils.checkNotNull(projectFilter, "projectFilter");
            this.projectFilter = projectFilter;
            return this;
        }

        public ActionSearchResponseDto build() {

            return new ActionSearchResponseDto(
                results, totalCount, query,
                connectorFilter, projectFilter);
        }

    }
}
