/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ApplicationAttachmentValue
 * 
 * <p>The content type of the attachment.
 */
public class ApplicationAttachmentValue {

    public static final ApplicationAttachmentValue TEXT = new ApplicationAttachmentValue("text");
    public static final ApplicationAttachmentValue PDF = new ApplicationAttachmentValue("pdf");
    public static final ApplicationAttachmentValue VIDEO = new ApplicationAttachmentValue("video");
    public static final ApplicationAttachmentValue OTHER = new ApplicationAttachmentValue("other");
    public static final ApplicationAttachmentValue UNMAPPED_VALUE = new ApplicationAttachmentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ApplicationAttachmentValue> values = createValuesMap();
    private static final Map<String, ApplicationAttachmentValueEnum> enums = createEnumsMap();

    private final String value;

    private ApplicationAttachmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ApplicationAttachmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ApplicationAttachmentValue
     */ 
    @JsonCreator
    public static ApplicationAttachmentValue of(String value) {
        synchronized (ApplicationAttachmentValue.class) {
            return values.computeIfAbsent(value, v -> new ApplicationAttachmentValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ApplicationAttachmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ApplicationAttachmentValue other = (ApplicationAttachmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ApplicationAttachmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ApplicationAttachmentValue[] values() {
        synchronized (ApplicationAttachmentValue.class) {
            return values.values().toArray(new ApplicationAttachmentValue[] {});
        }
    }

    private static final Map<String, ApplicationAttachmentValue> createValuesMap() {
        Map<String, ApplicationAttachmentValue> map = new LinkedHashMap<>();
        map.put("text", TEXT);
        map.put("pdf", PDF);
        map.put("video", VIDEO);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationAttachmentValueEnum> createEnumsMap() {
        Map<String, ApplicationAttachmentValueEnum> map = new HashMap<>();
        map.put("text", ApplicationAttachmentValueEnum.TEXT);
        map.put("pdf", ApplicationAttachmentValueEnum.PDF);
        map.put("video", ApplicationAttachmentValueEnum.VIDEO);
        map.put("other", ApplicationAttachmentValueEnum.OTHER);
        map.put("unmapped_value", ApplicationAttachmentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ApplicationAttachmentValueEnum {

        TEXT("text"),
        PDF("pdf"),
        VIDEO("video"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ApplicationAttachmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

