/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CampaignValue
 * 
 * <p>The schedule type of the campaign.
 */
public class CampaignValue {

    public static final CampaignValue IMMEDIATE = new CampaignValue("immediate");
    public static final CampaignValue SCHEDULED = new CampaignValue("scheduled");
    public static final CampaignValue RECURRING = new CampaignValue("recurring");
    public static final CampaignValue CUSTOM = new CampaignValue("custom");
    public static final CampaignValue TRIGGERED = new CampaignValue("triggered");
    public static final CampaignValue UNMAPPED_VALUE = new CampaignValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CampaignValue> values = createValuesMap();
    private static final Map<String, CampaignValueEnum> enums = createEnumsMap();

    private final String value;

    private CampaignValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CampaignValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CampaignValue
     */ 
    @JsonCreator
    public static CampaignValue of(String value) {
        synchronized (CampaignValue.class) {
            return values.computeIfAbsent(value, v -> new CampaignValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CampaignValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CampaignValue other = (CampaignValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CampaignValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CampaignValue[] values() {
        synchronized (CampaignValue.class) {
            return values.values().toArray(new CampaignValue[] {});
        }
    }

    private static final Map<String, CampaignValue> createValuesMap() {
        Map<String, CampaignValue> map = new LinkedHashMap<>();
        map.put("immediate", IMMEDIATE);
        map.put("scheduled", SCHEDULED);
        map.put("recurring", RECURRING);
        map.put("custom", CUSTOM);
        map.put("triggered", TRIGGERED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CampaignValueEnum> createEnumsMap() {
        Map<String, CampaignValueEnum> map = new HashMap<>();
        map.put("immediate", CampaignValueEnum.IMMEDIATE);
        map.put("scheduled", CampaignValueEnum.SCHEDULED);
        map.put("recurring", CampaignValueEnum.RECURRING);
        map.put("custom", CampaignValueEnum.CUSTOM);
        map.put("triggered", CampaignValueEnum.TRIGGERED);
        map.put("unmapped_value", CampaignValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CampaignValueEnum {

        IMMEDIATE("immediate"),
        SCHEDULED("scheduled"),
        RECURRING("recurring"),
        CUSTOM("custom"),
        TRIGGERED("triggered"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CampaignValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

