/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ChannelsEnumValue
 * 
 * <p>The Channels of the campaign.
 */
public class ChannelsEnumValue {

    public static final ChannelsEnumValue EMAIL = new ChannelsEnumValue("email");
    public static final ChannelsEnumValue SMS = new ChannelsEnumValue("sms");
    public static final ChannelsEnumValue WEB_PUSH = new ChannelsEnumValue("web_push");
    public static final ChannelsEnumValue IOS_PUSH = new ChannelsEnumValue("ios_push");
    public static final ChannelsEnumValue ANDROID_PUSH = new ChannelsEnumValue("android_push");
    public static final ChannelsEnumValue UNKNOWN = new ChannelsEnumValue("unknown");
    public static final ChannelsEnumValue UNMAPPED_VALUE = new ChannelsEnumValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ChannelsEnumValue> values = createValuesMap();
    private static final Map<String, ChannelsEnumValueEnum> enums = createEnumsMap();

    private final String value;

    private ChannelsEnumValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ChannelsEnumValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ChannelsEnumValue
     */ 
    @JsonCreator
    public static ChannelsEnumValue of(String value) {
        synchronized (ChannelsEnumValue.class) {
            return values.computeIfAbsent(value, v -> new ChannelsEnumValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ChannelsEnumValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ChannelsEnumValue other = (ChannelsEnumValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ChannelsEnumValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ChannelsEnumValue[] values() {
        synchronized (ChannelsEnumValue.class) {
            return values.values().toArray(new ChannelsEnumValue[] {});
        }
    }

    private static final Map<String, ChannelsEnumValue> createValuesMap() {
        Map<String, ChannelsEnumValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ChannelsEnumValueEnum> createEnumsMap() {
        Map<String, ChannelsEnumValueEnum> map = new HashMap<>();
        map.put("email", ChannelsEnumValueEnum.EMAIL);
        map.put("sms", ChannelsEnumValueEnum.SMS);
        map.put("web_push", ChannelsEnumValueEnum.WEB_PUSH);
        map.put("ios_push", ChannelsEnumValueEnum.IOS_PUSH);
        map.put("android_push", ChannelsEnumValueEnum.ANDROID_PUSH);
        map.put("unknown", ChannelsEnumValueEnum.UNKNOWN);
        map.put("unmapped_value", ChannelsEnumValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ChannelsEnumValueEnum {

        EMAIL("email"),
        SMS("sms"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ChannelsEnumValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

