/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ContentBlockStatusValue
 * 
 * <p>The Status of the content blocks.
 */
public class ContentBlockStatusValue {

    public static final ContentBlockStatusValue DRAFT = new ContentBlockStatusValue("draft");
    public static final ContentBlockStatusValue LIVE = new ContentBlockStatusValue("live");
    public static final ContentBlockStatusValue ARCHIVED = new ContentBlockStatusValue("archived");
    public static final ContentBlockStatusValue UNMAPPED_VALUE = new ContentBlockStatusValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ContentBlockStatusValue> values = createValuesMap();
    private static final Map<String, ContentBlockStatusValueEnum> enums = createEnumsMap();

    private final String value;

    private ContentBlockStatusValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ContentBlockStatusValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ContentBlockStatusValue
     */ 
    @JsonCreator
    public static ContentBlockStatusValue of(String value) {
        synchronized (ContentBlockStatusValue.class) {
            return values.computeIfAbsent(value, v -> new ContentBlockStatusValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ContentBlockStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ContentBlockStatusValue other = (ContentBlockStatusValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ContentBlockStatusValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ContentBlockStatusValue[] values() {
        synchronized (ContentBlockStatusValue.class) {
            return values.values().toArray(new ContentBlockStatusValue[] {});
        }
    }

    private static final Map<String, ContentBlockStatusValue> createValuesMap() {
        Map<String, ContentBlockStatusValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("live", LIVE);
        map.put("archived", ARCHIVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ContentBlockStatusValueEnum> createEnumsMap() {
        Map<String, ContentBlockStatusValueEnum> map = new HashMap<>();
        map.put("draft", ContentBlockStatusValueEnum.DRAFT);
        map.put("live", ContentBlockStatusValueEnum.LIVE);
        map.put("archived", ContentBlockStatusValueEnum.ARCHIVED);
        map.put("unmapped_value", ContentBlockStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ContentBlockStatusValueEnum {

        DRAFT("draft"),
        LIVE("live"),
        ARCHIVED("archived"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ContentBlockStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

