/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class HRISCostCenterValue {

    public static final HRISCostCenterValue WORKSPACE = new HRISCostCenterValue("workspace");
    public static final HRISCostCenterValue TEAM = new HRISCostCenterValue("team");
    public static final HRISCostCenterValue DEPARTMENT = new HRISCostCenterValue("department");
    public static final HRISCostCenterValue GROUP = new HRISCostCenterValue("group");
    public static final HRISCostCenterValue ORGANIZATION = new HRISCostCenterValue("organization");
    public static final HRISCostCenterValue UNMAPPED_VALUE = new HRISCostCenterValue("unmapped_value");
    public static final HRISCostCenterValue COST_CENTER = new HRISCostCenterValue("cost_center");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISCostCenterValue> values = createValuesMap();
    private static final Map<String, HRISCostCenterValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISCostCenterValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISCostCenterValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISCostCenterValue
     */ 
    @JsonCreator
    public static HRISCostCenterValue of(String value) {
        synchronized (HRISCostCenterValue.class) {
            return values.computeIfAbsent(value, v -> new HRISCostCenterValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HRISCostCenterValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISCostCenterValue other = (HRISCostCenterValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISCostCenterValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISCostCenterValue[] values() {
        synchronized (HRISCostCenterValue.class) {
            return values.values().toArray(new HRISCostCenterValue[] {});
        }
    }

    private static final Map<String, HRISCostCenterValue> createValuesMap() {
        Map<String, HRISCostCenterValue> map = new LinkedHashMap<>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, HRISCostCenterValueEnum> createEnumsMap() {
        Map<String, HRISCostCenterValueEnum> map = new HashMap<>();
        map.put("workspace", HRISCostCenterValueEnum.WORKSPACE);
        map.put("team", HRISCostCenterValueEnum.TEAM);
        map.put("department", HRISCostCenterValueEnum.DEPARTMENT);
        map.put("group", HRISCostCenterValueEnum.GROUP);
        map.put("organization", HRISCostCenterValueEnum.ORGANIZATION);
        map.put("unmapped_value", HRISCostCenterValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", HRISCostCenterValueEnum.COST_CENTER);
        return map;
    }
    
    
    public enum HRISCostCenterValueEnum {

        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center"),;

        private final String value;

        private HRISCostCenterValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

