/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * HrisShiftValue
 * 
 * <p>The status of the shift
 */
public class HrisShiftValue {

    public static final HrisShiftValue DRAFT = new HrisShiftValue("draft");
    public static final HrisShiftValue PUBLISHED = new HrisShiftValue("published");
    public static final HrisShiftValue CONFIRMED = new HrisShiftValue("confirmed");
    public static final HrisShiftValue CANCELLED = new HrisShiftValue("cancelled");
    public static final HrisShiftValue UNMAPPED_VALUE = new HrisShiftValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HrisShiftValue> values = createValuesMap();
    private static final Map<String, HrisShiftValueEnum> enums = createEnumsMap();

    private final String value;

    private HrisShiftValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HrisShiftValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HrisShiftValue
     */ 
    @JsonCreator
    public static HrisShiftValue of(String value) {
        synchronized (HrisShiftValue.class) {
            return values.computeIfAbsent(value, v -> new HrisShiftValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HrisShiftValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HrisShiftValue other = (HrisShiftValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HrisShiftValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HrisShiftValue[] values() {
        synchronized (HrisShiftValue.class) {
            return values.values().toArray(new HrisShiftValue[] {});
        }
    }

    private static final Map<String, HrisShiftValue> createValuesMap() {
        Map<String, HrisShiftValue> map = new LinkedHashMap<>();
        map.put("draft", DRAFT);
        map.put("published", PUBLISHED);
        map.put("confirmed", CONFIRMED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisShiftValueEnum> createEnumsMap() {
        Map<String, HrisShiftValueEnum> map = new HashMap<>();
        map.put("draft", HrisShiftValueEnum.DRAFT);
        map.put("published", HrisShiftValueEnum.PUBLISHED);
        map.put("confirmed", HrisShiftValueEnum.CONFIRMED);
        map.put("cancelled", HrisShiftValueEnum.CANCELLED);
        map.put("unmapped_value", HrisShiftValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum HrisShiftValueEnum {

        DRAFT("draft"),
        PUBLISHED("published"),
        CONFIRMED("confirmed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HrisShiftValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

