/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * MessageValue
 * 
 * <p>The unified message type.
 */
public class MessageValue {

    public static final MessageValue EMAIL = new MessageValue("email");
    public static final MessageValue SMS = new MessageValue("sms");
    public static final MessageValue PUSH = new MessageValue("push");
    public static final MessageValue WEB_PUSH = new MessageValue("web_push");
    public static final MessageValue IOS_PUSH = new MessageValue("ios_push");
    public static final MessageValue ANDROID_PUSH = new MessageValue("android_push");
    public static final MessageValue APP_PUSH = new MessageValue("app_push");
    public static final MessageValue OMNI_CHANNEL = new MessageValue("omni_channel");
    public static final MessageValue CONTENT_BLOCK = new MessageValue("content_block");
    public static final MessageValue IN_APP = new MessageValue("in_app");
    public static final MessageValue UNKNOWN = new MessageValue("unknown");
    public static final MessageValue UNMAPPED_VALUE = new MessageValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, MessageValue> values = createValuesMap();
    private static final Map<String, MessageValueEnum> enums = createEnumsMap();

    private final String value;

    private MessageValue(String value) {
        this.value = value;
    }

    /**
     * Returns a MessageValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as MessageValue
     */ 
    @JsonCreator
    public static MessageValue of(String value) {
        synchronized (MessageValue.class) {
            return values.computeIfAbsent(value, v -> new MessageValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<MessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MessageValue other = (MessageValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "MessageValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static MessageValue[] values() {
        synchronized (MessageValue.class) {
            return values.values().toArray(new MessageValue[] {});
        }
    }

    private static final Map<String, MessageValue> createValuesMap() {
        Map<String, MessageValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, MessageValueEnum> createEnumsMap() {
        Map<String, MessageValueEnum> map = new HashMap<>();
        map.put("email", MessageValueEnum.EMAIL);
        map.put("sms", MessageValueEnum.SMS);
        map.put("push", MessageValueEnum.PUSH);
        map.put("web_push", MessageValueEnum.WEB_PUSH);
        map.put("ios_push", MessageValueEnum.IOS_PUSH);
        map.put("android_push", MessageValueEnum.ANDROID_PUSH);
        map.put("app_push", MessageValueEnum.APP_PUSH);
        map.put("omni_channel", MessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", MessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", MessageValueEnum.IN_APP);
        map.put("unknown", MessageValueEnum.UNKNOWN);
        map.put("unmapped_value", MessageValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum MessageValueEnum {

        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private MessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

