/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * SkillsValue
 * 
 * <p>The unified skill level. For write operations: provide one of the listed enum values, or omit/set to
 * "unmapped_value" to use source_value instead.
 */
public class SkillsValue {

    public static final SkillsValue PRIMARY = new SkillsValue("primary");
    public static final SkillsValue SECONDARY = new SkillsValue("secondary");
    public static final SkillsValue TERTIARY = new SkillsValue("tertiary");
    public static final SkillsValue UNMAPPED_VALUE = new SkillsValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, SkillsValue> values = createValuesMap();
    private static final Map<String, SkillsValueEnum> enums = createEnumsMap();

    private final String value;

    private SkillsValue(String value) {
        this.value = value;
    }

    /**
     * Returns a SkillsValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as SkillsValue
     */ 
    @JsonCreator
    public static SkillsValue of(String value) {
        synchronized (SkillsValue.class) {
            return values.computeIfAbsent(value, v -> new SkillsValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<SkillsValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SkillsValue other = (SkillsValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "SkillsValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static SkillsValue[] values() {
        synchronized (SkillsValue.class) {
            return values.values().toArray(new SkillsValue[] {});
        }
    }

    private static final Map<String, SkillsValue> createValuesMap() {
        Map<String, SkillsValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsValueEnum> createEnumsMap() {
        Map<String, SkillsValueEnum> map = new HashMap<>();
        map.put("primary", SkillsValueEnum.PRIMARY);
        map.put("secondary", SkillsValueEnum.SECONDARY);
        map.put("tertiary", SkillsValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum SkillsValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private SkillsValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

