/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.errors;

import jakarta.annotation.Nullable;
import com.stackone.stackone_client_java.utils.Utils;

import java.io.IOException;
import java.net.http.HttpResponse;
import java.io.InputStream;

/**
 * Thrown by a service call when an error response occurs. Contains details about the response.
 */
@SuppressWarnings("serial")
public class SDKError extends StackOneError {

    public SDKError(
            String message,
            int code,
            @Nullable byte[] body,
            HttpResponse<InputStream> rawResponse,
            @Nullable Throwable cause) {
        super(message, code, body, rawResponse, cause);
    }

    public static SDKError from(String message, HttpResponse<InputStream> rawResponse) {
        return from(message, rawResponse, null);
    }

    public static SDKError from(String message, HttpResponse<InputStream> rawResponse, @Nullable Throwable cause) {
        try {
            return new SDKError(
                    message, rawResponse.statusCode(), Utils.extractByteArrayFromBody(rawResponse), rawResponse, cause);
        } catch (IOException e) {
            // Gracefully handle IOExceptions that occur while reading the body
            // by returning an error without a body.
            return new SDKError(
                    message, rawResponse.statusCode(), null, rawResponse, cause);
        }
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public HttpResponse<InputStream> rawResponse() {
        return (HttpResponse<InputStream>) super.rawResponse();
    }
}
