/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateCandidateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsCreateCandidateRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateCandidateRequestDto atsCreateCandidateRequestDto;

    @JsonCreator
    public AtsCreateCandidateRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
    }
    
    public AtsCreateCandidateRequest(
            String xAccountId,
            AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateCandidateRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateCandidateRequestDto atsCreateCandidateRequestDto() {
        return atsCreateCandidateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsCreateCandidateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateCandidateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateCandidateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateCandidateRequest withAtsCreateCandidateRequestDto(AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
        Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
        this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateCandidateRequest other = (AtsCreateCandidateRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateCandidateRequestDto, other.atsCreateCandidateRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateCandidateRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateCandidateRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateCandidateRequestDto", atsCreateCandidateRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateCandidateRequestDto atsCreateCandidateRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateCandidateRequestDto(AtsCreateCandidateRequestDto atsCreateCandidateRequestDto) {
            Utils.checkNotNull(atsCreateCandidateRequestDto, "atsCreateCandidateRequestDto");
            this.atsCreateCandidateRequestDto = atsCreateCandidateRequestDto;
            return this;
        }

        public AtsCreateCandidateRequest build() {

            return new AtsCreateCandidateRequest(
                xAccountId, prefer, atsCreateCandidateRequestDto);
        }

    }
}
