/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateOfferRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsCreateOfferRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateOfferRequestDto atsCreateOfferRequestDto;

    @JsonCreator
    public AtsCreateOfferRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
    }
    
    public AtsCreateOfferRequest(
            String xAccountId,
            AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateOfferRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateOfferRequestDto atsCreateOfferRequestDto() {
        return atsCreateOfferRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsCreateOfferRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateOfferRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsCreateOfferRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsCreateOfferRequest withAtsCreateOfferRequestDto(AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
        Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
        this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateOfferRequest other = (AtsCreateOfferRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateOfferRequestDto, other.atsCreateOfferRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateOfferRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateOfferRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateOfferRequestDto", atsCreateOfferRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateOfferRequestDto atsCreateOfferRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateOfferRequestDto(AtsCreateOfferRequestDto atsCreateOfferRequestDto) {
            Utils.checkNotNull(atsCreateOfferRequestDto, "atsCreateOfferRequestDto");
            this.atsCreateOfferRequestDto = atsCreateOfferRequestDto;
            return this;
        }

        public AtsCreateOfferRequest build() {

            return new AtsCreateOfferRequest(
                xAccountId, prefer, atsCreateOfferRequestDto);
        }

    }
}
