/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateBackgroundCheckOrderRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsOrderBackgroundCheckRequestRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto;

    @JsonCreator
    public AtsOrderBackgroundCheckRequestRequest(
            String xAccountId,
            Optional<String> prefer,
            AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
    }
    
    public AtsOrderBackgroundCheckRequestRequest(
            String xAccountId,
            AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateBackgroundCheckOrderRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto() {
        return atsCreateBackgroundCheckOrderRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsOrderBackgroundCheckRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsOrderBackgroundCheckRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsOrderBackgroundCheckRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsOrderBackgroundCheckRequestRequest withAtsCreateBackgroundCheckOrderRequestDto(AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
        this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsOrderBackgroundCheckRequestRequest other = (AtsOrderBackgroundCheckRequestRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsCreateBackgroundCheckOrderRequestDto, other.atsCreateBackgroundCheckOrderRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, prefer, atsCreateBackgroundCheckOrderRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsOrderBackgroundCheckRequestRequest.class,
                "xAccountId", xAccountId,
                "prefer", prefer,
                "atsCreateBackgroundCheckOrderRequestDto", atsCreateBackgroundCheckOrderRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsCreateBackgroundCheckOrderRequestDto(AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
            Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
            this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
            return this;
        }

        public AtsOrderBackgroundCheckRequestRequest build() {

            return new AtsOrderBackgroundCheckRequestRequest(
                xAccountId, prefer, atsCreateBackgroundCheckOrderRequestDto);
        }

    }
}
