/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsUpdateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class AtsUpdateJobRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

    @JsonCreator
    public AtsUpdateJobRequest(
            String xAccountId,
            String id,
            Optional<String> prefer,
            AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
    }
    
    public AtsUpdateJobRequest(
            String xAccountId,
            String id,
            AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        this(xAccountId, id, Optional.empty(),
            atsUpdateJobRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public AtsUpdateJobRequestDto atsUpdateJobRequestDto() {
        return atsUpdateJobRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsUpdateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateJobRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsUpdateJobRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public AtsUpdateJobRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsUpdateJobRequest withAtsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateJobRequest other = (AtsUpdateJobRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.atsUpdateJobRequestDto, other.atsUpdateJobRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, prefer,
            atsUpdateJobRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsUpdateJobRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "prefer", prefer,
                "atsUpdateJobRequestDto", atsUpdateJobRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private Optional<String> prefer = Optional.empty();

        private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder atsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
            Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
            this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
            return this;
        }

        public AtsUpdateJobRequest build() {

            return new AtsUpdateJobRequest(
                xAccountId, id, prefer,
                atsUpdateJobRequestDto);
        }

    }
}
