/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;


public class HrisGetEmployeesWorkEligibilityRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default
     * value is false)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=raw")
    private JsonNullable<Boolean> raw;

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by
     * surrounding them with 'proxy' key
     */
    @SpeakeasyMetadata("queryParam:style=deepObject,explode=true,name=proxy")
    private JsonNullable<? extends Map<String, Object>> proxy;

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are
     * returned)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=fields")
    private JsonNullable<String> fields;

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public HrisGetEmployeesWorkEligibilityRequest(
            String id,
            String subResourceId,
            JsonNullable<Boolean> raw,
            JsonNullable<? extends Map<String, Object>> proxy,
            JsonNullable<String> fields,
            String xAccountId,
            Optional<String> prefer) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(raw, "raw");
        Utils.checkNotNull(proxy, "proxy");
        Utils.checkNotNull(fields, "fields");
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        this.id = id;
        this.subResourceId = subResourceId;
        this.raw = raw;
        this.proxy = proxy;
        this.fields = fields;
        this.xAccountId = xAccountId;
        this.prefer = prefer;
    }
    
    public HrisGetEmployeesWorkEligibilityRequest(
            String id,
            String subResourceId,
            String xAccountId) {
        this(id, subResourceId, JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), xAccountId,
            Optional.empty());
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default
     * value is false)
     */
    @JsonIgnore
    public JsonNullable<Boolean> raw() {
        return raw;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by
     * surrounding them with 'proxy' key
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> proxy() {
        return (JsonNullable<Map<String, Object>>) proxy;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are
     * returned)
     */
    @JsonIgnore
    public JsonNullable<String> fields() {
        return fields;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    public static Builder builder() {
        return new Builder();
    }


    public HrisGetEmployeesWorkEligibilityRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisGetEmployeesWorkEligibilityRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default
     * value is false)
     */
    public HrisGetEmployeesWorkEligibilityRequest withRaw(boolean raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    /**
     * Indicates that the raw request result should be returned in addition to the mapped result (default
     * value is false)
     */
    public HrisGetEmployeesWorkEligibilityRequest withRaw(JsonNullable<Boolean> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by
     * surrounding them with 'proxy' key
     */
    public HrisGetEmployeesWorkEligibilityRequest withProxy(Map<String, Object> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = JsonNullable.of(proxy);
        return this;
    }

    /**
     * Query parameters that can be used to pass through parameters to the underlying provider request by
     * surrounding them with 'proxy' key
     */
    public HrisGetEmployeesWorkEligibilityRequest withProxy(JsonNullable<? extends Map<String, Object>> proxy) {
        Utils.checkNotNull(proxy, "proxy");
        this.proxy = proxy;
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are
     * returned)
     */
    public HrisGetEmployeesWorkEligibilityRequest withFields(String fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = JsonNullable.of(fields);
        return this;
    }

    /**
     * The comma separated list of fields that will be returned in the response (if empty, all fields are
     * returned)
     */
    public HrisGetEmployeesWorkEligibilityRequest withFields(JsonNullable<String> fields) {
        Utils.checkNotNull(fields, "fields");
        this.fields = fields;
        return this;
    }

    /**
     * The account identifier
     */
    public HrisGetEmployeesWorkEligibilityRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisGetEmployeesWorkEligibilityRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisGetEmployeesWorkEligibilityRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeesWorkEligibilityRequest other = (HrisGetEmployeesWorkEligibilityRequest) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) &&
            Utils.enhancedDeepEquals(this.raw, other.raw) &&
            Utils.enhancedDeepEquals(this.proxy, other.proxy) &&
            Utils.enhancedDeepEquals(this.fields, other.fields) &&
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, subResourceId, raw,
            proxy, fields, xAccountId,
            prefer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisGetEmployeesWorkEligibilityRequest.class,
                "id", id,
                "subResourceId", subResourceId,
                "raw", raw,
                "proxy", proxy,
                "fields", fields,
                "xAccountId", xAccountId,
                "prefer", prefer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String id;

        private String subResourceId;

        private JsonNullable<Boolean> raw = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> proxy = JsonNullable.undefined();

        private JsonNullable<String> fields = JsonNullable.undefined();

        private String xAccountId;

        private Optional<String> prefer = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }


        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default
         * value is false)
         */
        public Builder raw(boolean raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        /**
         * Indicates that the raw request result should be returned in addition to the mapped result (default
         * value is false)
         */
        public Builder raw(JsonNullable<Boolean> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }


        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by
         * surrounding them with 'proxy' key
         */
        public Builder proxy(Map<String, Object> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = JsonNullable.of(proxy);
            return this;
        }

        /**
         * Query parameters that can be used to pass through parameters to the underlying provider request by
         * surrounding them with 'proxy' key
         */
        public Builder proxy(JsonNullable<? extends Map<String, Object>> proxy) {
            Utils.checkNotNull(proxy, "proxy");
            this.proxy = proxy;
            return this;
        }


        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are
         * returned)
         */
        public Builder fields(String fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = JsonNullable.of(fields);
            return this;
        }

        /**
         * The comma separated list of fields that will be returned in the response (if empty, all fields are
         * returned)
         */
        public Builder fields(JsonNullable<String> fields) {
            Utils.checkNotNull(fields, "fields");
            this.fields = fields;
            return this;
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public HrisGetEmployeesWorkEligibilityRequest build() {

            return new HrisGetEmployeesWorkEligibilityRequest(
                id, subResourceId, raw,
                proxy, fields, xAccountId,
                prefer);
        }

    }
}
