/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CampaignValue {
    public static final CampaignValue IMMEDIATE = new CampaignValue("immediate");
    public static final CampaignValue SCHEDULED = new CampaignValue("scheduled");
    public static final CampaignValue RECURRING = new CampaignValue("recurring");
    public static final CampaignValue CUSTOM = new CampaignValue("custom");
    public static final CampaignValue TRIGGERED = new CampaignValue("triggered");
    public static final CampaignValue UNMAPPED_VALUE = new CampaignValue("unmapped_value");
    private static final Map<String, CampaignValue> values = CampaignValue.createValuesMap();
    private static final Map<String, CampaignValueEnum> enums = CampaignValue.createEnumsMap();
    private final String value;

    private CampaignValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CampaignValue of(String value) {
        Class<CampaignValue> clazz = CampaignValue.class;
        synchronized (CampaignValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CampaignValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CampaignValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CampaignValue other = (CampaignValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CampaignValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CampaignValue[] values() {
        Class<CampaignValue> clazz = CampaignValue.class;
        synchronized (CampaignValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CampaignValue[0]);
        }
    }

    private static final Map<String, CampaignValue> createValuesMap() {
        LinkedHashMap<String, CampaignValue> map = new LinkedHashMap<String, CampaignValue>();
        map.put("immediate", IMMEDIATE);
        map.put("scheduled", SCHEDULED);
        map.put("recurring", RECURRING);
        map.put("custom", CUSTOM);
        map.put("triggered", TRIGGERED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CampaignValueEnum> createEnumsMap() {
        HashMap<String, CampaignValueEnum> map = new HashMap<String, CampaignValueEnum>();
        map.put("immediate", CampaignValueEnum.IMMEDIATE);
        map.put("scheduled", CampaignValueEnum.SCHEDULED);
        map.put("recurring", CampaignValueEnum.RECURRING);
        map.put("custom", CampaignValueEnum.CUSTOM);
        map.put("triggered", CampaignValueEnum.TRIGGERED);
        map.put("unmapped_value", CampaignValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CampaignValueEnum {
        IMMEDIATE("immediate"),
        SCHEDULED("scheduled"),
        RECURRING("recurring"),
        CUSTOM("custom"),
        TRIGGERED("triggered"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CampaignValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

