/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CategoryValue {
    public static final CategoryValue PRIMARY = new CategoryValue("primary");
    public static final CategoryValue SECONDARY = new CategoryValue("secondary");
    public static final CategoryValue TERTIARY = new CategoryValue("tertiary");
    public static final CategoryValue UNMAPPED_VALUE = new CategoryValue("unmapped_value");
    private static final Map<String, CategoryValue> values = CategoryValue.createValuesMap();
    private static final Map<String, CategoryValueEnum> enums = CategoryValue.createEnumsMap();
    private final String value;

    private CategoryValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CategoryValue of(String value) {
        Class<CategoryValue> clazz = CategoryValue.class;
        synchronized (CategoryValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CategoryValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CategoryValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryValue other = (CategoryValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CategoryValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryValue[] values() {
        Class<CategoryValue> clazz = CategoryValue.class;
        synchronized (CategoryValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CategoryValue[0]);
        }
    }

    private static final Map<String, CategoryValue> createValuesMap() {
        LinkedHashMap<String, CategoryValue> map = new LinkedHashMap<String, CategoryValue>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CategoryValueEnum> createEnumsMap() {
        HashMap<String, CategoryValueEnum> map = new HashMap<String, CategoryValueEnum>();
        map.put("primary", CategoryValueEnum.PRIMARY);
        map.put("secondary", CategoryValueEnum.SECONDARY);
        map.put("tertiary", CategoryValueEnum.TERTIARY);
        map.put("unmapped_value", CategoryValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CategoryValueEnum {
        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CategoryValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

