/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class CompletionScore {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="percentage")
    private JsonNullable<Double> percentage;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw_value")
    private JsonNullable<String> rawValue;

    @JsonCreator
    public CompletionScore(@JsonProperty(value="percentage") JsonNullable<Double> percentage, @JsonProperty(value="raw_value") JsonNullable<String> rawValue) {
        Utils.checkNotNull(percentage, "percentage");
        Utils.checkNotNull(rawValue, "rawValue");
        this.percentage = percentage;
        this.rawValue = rawValue;
    }

    public CompletionScore() {
        this((JsonNullable<Double>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<Double> percentage() {
        return this.percentage;
    }

    @JsonIgnore
    public JsonNullable<String> rawValue() {
        return this.rawValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletionScore withPercentage(double percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = JsonNullable.of((Object)percentage);
        return this;
    }

    public CompletionScore withPercentage(JsonNullable<Double> percentage) {
        Utils.checkNotNull(percentage, "percentage");
        this.percentage = percentage;
        return this;
    }

    public CompletionScore withRawValue(String rawValue) {
        Utils.checkNotNull(rawValue, "rawValue");
        this.rawValue = JsonNullable.of((Object)rawValue);
        return this;
    }

    public CompletionScore withRawValue(JsonNullable<String> rawValue) {
        Utils.checkNotNull(rawValue, "rawValue");
        this.rawValue = rawValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionScore other = (CompletionScore)o;
        return Utils.enhancedDeepEquals(this.percentage, other.percentage) && Utils.enhancedDeepEquals(this.rawValue, other.rawValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.percentage, this.rawValue);
    }

    public String toString() {
        return Utils.toString(CompletionScore.class, "percentage", this.percentage, "rawValue", this.rawValue);
    }

    public static final class Builder {
        private JsonNullable<Double> percentage = JsonNullable.undefined();
        private JsonNullable<String> rawValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder percentage(double percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = JsonNullable.of((Object)percentage);
            return this;
        }

        public Builder percentage(JsonNullable<Double> percentage) {
            Utils.checkNotNull(percentage, "percentage");
            this.percentage = percentage;
            return this;
        }

        public Builder rawValue(String rawValue) {
            Utils.checkNotNull(rawValue, "rawValue");
            this.rawValue = JsonNullable.of((Object)rawValue);
            return this;
        }

        public Builder rawValue(JsonNullable<String> rawValue) {
            Utils.checkNotNull(rawValue, "rawValue");
            this.rawValue = rawValue;
            return this;
        }

        public CompletionScore build() {
            return new CompletionScore(this.percentage, this.rawValue);
        }
    }
}

