/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentWorkTimeValue {
    public static final EmploymentWorkTimeValue DAY = new EmploymentWorkTimeValue("day");
    public static final EmploymentWorkTimeValue WEEK = new EmploymentWorkTimeValue("week");
    public static final EmploymentWorkTimeValue MONTH = new EmploymentWorkTimeValue("month");
    public static final EmploymentWorkTimeValue YEAR = new EmploymentWorkTimeValue("year");
    public static final EmploymentWorkTimeValue UNMAPPED_VALUE = new EmploymentWorkTimeValue("unmapped_value");
    private static final Map<String, EmploymentWorkTimeValue> values = EmploymentWorkTimeValue.createValuesMap();
    private static final Map<String, EmploymentWorkTimeValueEnum> enums = EmploymentWorkTimeValue.createEnumsMap();
    private final String value;

    private EmploymentWorkTimeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentWorkTimeValue of(String value) {
        Class<EmploymentWorkTimeValue> clazz = EmploymentWorkTimeValue.class;
        synchronized (EmploymentWorkTimeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentWorkTimeValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentWorkTimeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentWorkTimeValue other = (EmploymentWorkTimeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentWorkTimeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentWorkTimeValue[] values() {
        Class<EmploymentWorkTimeValue> clazz = EmploymentWorkTimeValue.class;
        synchronized (EmploymentWorkTimeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentWorkTimeValue[0]);
        }
    }

    private static final Map<String, EmploymentWorkTimeValue> createValuesMap() {
        LinkedHashMap<String, EmploymentWorkTimeValue> map = new LinkedHashMap<String, EmploymentWorkTimeValue>();
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("month", MONTH);
        map.put("year", YEAR);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmploymentWorkTimeValueEnum> createEnumsMap() {
        HashMap<String, EmploymentWorkTimeValueEnum> map = new HashMap<String, EmploymentWorkTimeValueEnum>();
        map.put("day", EmploymentWorkTimeValueEnum.DAY);
        map.put("week", EmploymentWorkTimeValueEnum.WEEK);
        map.put("month", EmploymentWorkTimeValueEnum.MONTH);
        map.put("year", EmploymentWorkTimeValueEnum.YEAR);
        map.put("unmapped_value", EmploymentWorkTimeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmploymentWorkTimeValueEnum {
        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmploymentWorkTimeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

