/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HRISBenefitValue {
    public static final HRISBenefitValue RETIREMENT_SAVINGS = new HRISBenefitValue("retirement_savings");
    public static final HRISBenefitValue HEALTH_SAVINGS = new HRISBenefitValue("health_savings");
    public static final HRISBenefitValue OTHER = new HRISBenefitValue("other");
    public static final HRISBenefitValue HEALTH_INSURANCE = new HRISBenefitValue("health_insurance");
    public static final HRISBenefitValue INSURANCE = new HRISBenefitValue("insurance");
    public static final HRISBenefitValue UNMAPPED_VALUE = new HRISBenefitValue("unmapped_value");
    private static final Map<String, HRISBenefitValue> values = HRISBenefitValue.createValuesMap();
    private static final Map<String, HRISBenefitValueEnum> enums = HRISBenefitValue.createEnumsMap();
    private final String value;

    private HRISBenefitValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HRISBenefitValue of(String value) {
        Class<HRISBenefitValue> clazz = HRISBenefitValue.class;
        synchronized (HRISBenefitValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISBenefitValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HRISBenefitValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISBenefitValue other = (HRISBenefitValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISBenefitValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISBenefitValue[] values() {
        Class<HRISBenefitValue> clazz = HRISBenefitValue.class;
        synchronized (HRISBenefitValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISBenefitValue[0]);
        }
    }

    private static final Map<String, HRISBenefitValue> createValuesMap() {
        LinkedHashMap<String, HRISBenefitValue> map = new LinkedHashMap<String, HRISBenefitValue>();
        map.put("retirement_savings", RETIREMENT_SAVINGS);
        map.put("health_savings", HEALTH_SAVINGS);
        map.put("other", OTHER);
        map.put("health_insurance", HEALTH_INSURANCE);
        map.put("insurance", INSURANCE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISBenefitValueEnum> createEnumsMap() {
        HashMap<String, HRISBenefitValueEnum> map = new HashMap<String, HRISBenefitValueEnum>();
        map.put("retirement_savings", HRISBenefitValueEnum.RETIREMENT_SAVINGS);
        map.put("health_savings", HRISBenefitValueEnum.HEALTH_SAVINGS);
        map.put("other", HRISBenefitValueEnum.OTHER);
        map.put("health_insurance", HRISBenefitValueEnum.HEALTH_INSURANCE);
        map.put("insurance", HRISBenefitValueEnum.INSURANCE);
        map.put("unmapped_value", HRISBenefitValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HRISBenefitValueEnum {
        RETIREMENT_SAVINGS("retirement_savings"),
        HEALTH_SAVINGS("health_savings"),
        OTHER("other"),
        HEALTH_INSURANCE("health_insurance"),
        INSURANCE("insurance"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HRISBenefitValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

