/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InterviewValue {
    public static final InterviewValue UNSCHEDULED = new InterviewValue("unscheduled");
    public static final InterviewValue SCHEDULED = new InterviewValue("scheduled");
    public static final InterviewValue COMPLETED = new InterviewValue("completed");
    public static final InterviewValue CANCELLED = new InterviewValue("cancelled");
    public static final InterviewValue PENDING_FEEDBACK = new InterviewValue("pending_feedback");
    public static final InterviewValue UNMAPPED_VALUE = new InterviewValue("unmapped_value");
    private static final Map<String, InterviewValue> values = InterviewValue.createValuesMap();
    private static final Map<String, InterviewValueEnum> enums = InterviewValue.createEnumsMap();
    private final String value;

    private InterviewValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static InterviewValue of(String value) {
        Class<InterviewValue> clazz = InterviewValue.class;
        synchronized (InterviewValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new InterviewValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<InterviewValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterviewValue other = (InterviewValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "InterviewValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterviewValue[] values() {
        Class<InterviewValue> clazz = InterviewValue.class;
        synchronized (InterviewValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new InterviewValue[0]);
        }
    }

    private static final Map<String, InterviewValue> createValuesMap() {
        LinkedHashMap<String, InterviewValue> map = new LinkedHashMap<String, InterviewValue>();
        map.put("unscheduled", UNSCHEDULED);
        map.put("scheduled", SCHEDULED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("pending_feedback", PENDING_FEEDBACK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InterviewValueEnum> createEnumsMap() {
        HashMap<String, InterviewValueEnum> map = new HashMap<String, InterviewValueEnum>();
        map.put("unscheduled", InterviewValueEnum.UNSCHEDULED);
        map.put("scheduled", InterviewValueEnum.SCHEDULED);
        map.put("completed", InterviewValueEnum.COMPLETED);
        map.put("cancelled", InterviewValueEnum.CANCELLED);
        map.put("pending_feedback", InterviewValueEnum.PENDING_FEEDBACK);
        map.put("unmapped_value", InterviewValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum InterviewValueEnum {
        UNSCHEDULED("unscheduled"),
        SCHEDULED("scheduled"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        PENDING_FEEDBACK("pending_feedback"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private InterviewValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

