/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ScheduledInterviewValue {
    public static final ScheduledInterviewValue UNSCHEDULED = new ScheduledInterviewValue("unscheduled");
    public static final ScheduledInterviewValue SCHEDULED = new ScheduledInterviewValue("scheduled");
    public static final ScheduledInterviewValue COMPLETED = new ScheduledInterviewValue("completed");
    public static final ScheduledInterviewValue CANCELLED = new ScheduledInterviewValue("cancelled");
    public static final ScheduledInterviewValue PENDING_FEEDBACK = new ScheduledInterviewValue("pending_feedback");
    public static final ScheduledInterviewValue UNMAPPED_VALUE = new ScheduledInterviewValue("unmapped_value");
    private static final Map<String, ScheduledInterviewValue> values = ScheduledInterviewValue.createValuesMap();
    private static final Map<String, ScheduledInterviewValueEnum> enums = ScheduledInterviewValue.createEnumsMap();
    private final String value;

    private ScheduledInterviewValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ScheduledInterviewValue of(String value) {
        Class<ScheduledInterviewValue> clazz = ScheduledInterviewValue.class;
        synchronized (ScheduledInterviewValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ScheduledInterviewValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ScheduledInterviewValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledInterviewValue other = (ScheduledInterviewValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ScheduledInterviewValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduledInterviewValue[] values() {
        Class<ScheduledInterviewValue> clazz = ScheduledInterviewValue.class;
        synchronized (ScheduledInterviewValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ScheduledInterviewValue[0]);
        }
    }

    private static final Map<String, ScheduledInterviewValue> createValuesMap() {
        LinkedHashMap<String, ScheduledInterviewValue> map = new LinkedHashMap<String, ScheduledInterviewValue>();
        map.put("unscheduled", UNSCHEDULED);
        map.put("scheduled", SCHEDULED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("pending_feedback", PENDING_FEEDBACK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ScheduledInterviewValueEnum> createEnumsMap() {
        HashMap<String, ScheduledInterviewValueEnum> map = new HashMap<String, ScheduledInterviewValueEnum>();
        map.put("unscheduled", ScheduledInterviewValueEnum.UNSCHEDULED);
        map.put("scheduled", ScheduledInterviewValueEnum.SCHEDULED);
        map.put("completed", ScheduledInterviewValueEnum.COMPLETED);
        map.put("cancelled", ScheduledInterviewValueEnum.CANCELLED);
        map.put("pending_feedback", ScheduledInterviewValueEnum.PENDING_FEEDBACK);
        map.put("unmapped_value", ScheduledInterviewValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ScheduledInterviewValueEnum {
        UNSCHEDULED("unscheduled"),
        SCHEDULED("scheduled"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        PENDING_FEEDBACK("pending_feedback"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ScheduledInterviewValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

