/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TaskStatusValue {
    public static final TaskStatusValue OPEN = new TaskStatusValue("open");
    public static final TaskStatusValue IN_PROGRESS = new TaskStatusValue("in_progress");
    public static final TaskStatusValue BLOCKED = new TaskStatusValue("blocked");
    public static final TaskStatusValue COMPLETED = new TaskStatusValue("completed");
    public static final TaskStatusValue CANCELLED = new TaskStatusValue("cancelled");
    public static final TaskStatusValue UNMAPPED_VALUE = new TaskStatusValue("unmapped_value");
    private static final Map<String, TaskStatusValue> values = TaskStatusValue.createValuesMap();
    private static final Map<String, TaskStatusValueEnum> enums = TaskStatusValue.createEnumsMap();
    private final String value;

    private TaskStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TaskStatusValue of(String value) {
        Class<TaskStatusValue> clazz = TaskStatusValue.class;
        synchronized (TaskStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TaskStatusValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TaskStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskStatusValue other = (TaskStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TaskStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskStatusValue[] values() {
        Class<TaskStatusValue> clazz = TaskStatusValue.class;
        synchronized (TaskStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TaskStatusValue[0]);
        }
    }

    private static final Map<String, TaskStatusValue> createValuesMap() {
        LinkedHashMap<String, TaskStatusValue> map = new LinkedHashMap<String, TaskStatusValue>();
        map.put("open", OPEN);
        map.put("in_progress", IN_PROGRESS);
        map.put("blocked", BLOCKED);
        map.put("completed", COMPLETED);
        map.put("cancelled", CANCELLED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TaskStatusValueEnum> createEnumsMap() {
        HashMap<String, TaskStatusValueEnum> map = new HashMap<String, TaskStatusValueEnum>();
        map.put("open", TaskStatusValueEnum.OPEN);
        map.put("in_progress", TaskStatusValueEnum.IN_PROGRESS);
        map.put("blocked", TaskStatusValueEnum.BLOCKED);
        map.put("completed", TaskStatusValueEnum.COMPLETED);
        map.put("cancelled", TaskStatusValueEnum.CANCELLED);
        map.put("unmapped_value", TaskStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TaskStatusValueEnum {
        OPEN("open"),
        IN_PROGRESS("in_progress"),
        BLOCKED("blocked"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TaskStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

