/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TimeEntriesValue {
    public static final TimeEntriesValue APPROVED = new TimeEntriesValue("approved");
    public static final TimeEntriesValue UNMAPPED_VALUE = new TimeEntriesValue("unmapped_value");
    private static final Map<String, TimeEntriesValue> values = TimeEntriesValue.createValuesMap();
    private static final Map<String, TimeEntriesValueEnum> enums = TimeEntriesValue.createEnumsMap();
    private final String value;

    private TimeEntriesValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static TimeEntriesValue of(String value) {
        Class<TimeEntriesValue> clazz = TimeEntriesValue.class;
        synchronized (TimeEntriesValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new TimeEntriesValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<TimeEntriesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeEntriesValue other = (TimeEntriesValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "TimeEntriesValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeEntriesValue[] values() {
        Class<TimeEntriesValue> clazz = TimeEntriesValue.class;
        synchronized (TimeEntriesValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new TimeEntriesValue[0]);
        }
    }

    private static final Map<String, TimeEntriesValue> createValuesMap() {
        LinkedHashMap<String, TimeEntriesValue> map = new LinkedHashMap<String, TimeEntriesValue>();
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeEntriesValueEnum> createEnumsMap() {
        HashMap<String, TimeEntriesValueEnum> map = new HashMap<String, TimeEntriesValueEnum>();
        map.put("approved", TimeEntriesValueEnum.APPROVED);
        map.put("unmapped_value", TimeEntriesValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum TimeEntriesValueEnum {
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private TimeEntriesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

