/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AccountingCreateCompanyJournalRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;

    @JsonCreator
    public AccountingCreateCompanyJournalRequest(String xAccountId, String id, Optional<String> prefer, AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
    }

    public AccountingCreateCompanyJournalRequest(String xAccountId, String id, AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        this(xAccountId, id, Optional.empty(), accountingJournalCreateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AccountingJournalCreateRequestDto accountingJournalCreateRequestDto() {
        return this.accountingJournalCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingCreateCompanyJournalRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingCreateCompanyJournalRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AccountingCreateCompanyJournalRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AccountingCreateCompanyJournalRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AccountingCreateCompanyJournalRequest withAccountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
        Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
        this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingCreateCompanyJournalRequest other = (AccountingCreateCompanyJournalRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.accountingJournalCreateRequestDto, other.accountingJournalCreateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.accountingJournalCreateRequestDto);
    }

    public String toString() {
        return Utils.toString(AccountingCreateCompanyJournalRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "accountingJournalCreateRequestDto", this.accountingJournalCreateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AccountingJournalCreateRequestDto accountingJournalCreateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder accountingJournalCreateRequestDto(AccountingJournalCreateRequestDto accountingJournalCreateRequestDto) {
            Utils.checkNotNull(accountingJournalCreateRequestDto, "accountingJournalCreateRequestDto");
            this.accountingJournalCreateRequestDto = accountingJournalCreateRequestDto;
            return this;
        }

        public AccountingCreateCompanyJournalRequest build() {
            return new AccountingCreateCompanyJournalRequest(this.xAccountId, this.id, this.prefer, this.accountingJournalCreateRequestDto);
        }
    }
}

