/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsUpdateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUpdateJobRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

    @JsonCreator
    public AtsUpdateJobRequest(String xAccountId, String id, Optional<String> prefer, AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
    }

    public AtsUpdateJobRequest(String xAccountId, String id, AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        this(xAccountId, id, Optional.empty(), atsUpdateJobRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsUpdateJobRequestDto atsUpdateJobRequestDto() {
        return this.atsUpdateJobRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsUpdateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateJobRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateJobRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsUpdateJobRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsUpdateJobRequest withAtsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateJobRequest other = (AtsUpdateJobRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsUpdateJobRequestDto, other.atsUpdateJobRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.atsUpdateJobRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsUpdateJobRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "atsUpdateJobRequestDto", this.atsUpdateJobRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
            Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
            this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
            return this;
        }

        public AtsUpdateJobRequest build() {
            return new AtsUpdateJobRequest(this.xAccountId, this.id, this.prefer, this.atsUpdateJobRequestDto);
        }
    }
}

