/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class DocumentsDownloadFileRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-stackone-api-session-token")
    private Optional<String> xStackoneApiSessionToken;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=format")
    private JsonNullable<String> format;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=export_format")
    private JsonNullable<String> exportFormat;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;

    @JsonCreator
    public DocumentsDownloadFileRequest(String xAccountId, Optional<String> xStackoneApiSessionToken, String id, JsonNullable<String> format, JsonNullable<String> exportFormat, Optional<String> prefer) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(format, "format");
        Utils.checkNotNull(exportFormat, "exportFormat");
        Utils.checkNotNull(prefer, "prefer");
        this.xAccountId = xAccountId;
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        this.id = id;
        this.format = format;
        this.exportFormat = exportFormat;
        this.prefer = prefer;
    }

    public DocumentsDownloadFileRequest(String xAccountId, String id) {
        this(xAccountId, Optional.empty(), id, (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), Optional.empty());
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> xStackoneApiSessionToken() {
        return this.xStackoneApiSessionToken;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> format() {
        return this.format;
    }

    @JsonIgnore
    public JsonNullable<String> exportFormat() {
        return this.exportFormat;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DocumentsDownloadFileRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public DocumentsDownloadFileRequest withXStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
        return this;
    }

    public DocumentsDownloadFileRequest withXStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsDownloadFileRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public DocumentsDownloadFileRequest withFormat(String format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of((Object)format);
        return this;
    }

    public DocumentsDownloadFileRequest withFormat(JsonNullable<String> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    public DocumentsDownloadFileRequest withExportFormat(String exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = JsonNullable.of((Object)exportFormat);
        return this;
    }

    public DocumentsDownloadFileRequest withExportFormat(JsonNullable<String> exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = exportFormat;
        return this;
    }

    public DocumentsDownloadFileRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public DocumentsDownloadFileRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsDownloadFileRequest other = (DocumentsDownloadFileRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.xStackoneApiSessionToken, other.xStackoneApiSessionToken) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.format, other.format) && Utils.enhancedDeepEquals(this.exportFormat, other.exportFormat) && Utils.enhancedDeepEquals(this.prefer, other.prefer);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.xStackoneApiSessionToken, this.id, this.format, this.exportFormat, this.prefer);
    }

    public String toString() {
        return Utils.toString(DocumentsDownloadFileRequest.class, "xAccountId", this.xAccountId, "xStackoneApiSessionToken", this.xStackoneApiSessionToken, "id", this.id, "format", this.format, "exportFormat", this.exportFormat, "prefer", this.prefer);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> xStackoneApiSessionToken = Optional.empty();
        private String id;
        private JsonNullable<String> format = JsonNullable.undefined();
        private JsonNullable<String> exportFormat = JsonNullable.undefined();
        private Optional<String> prefer = Optional.empty();

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = Optional.ofNullable(xStackoneApiSessionToken);
            return this;
        }

        public Builder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
            Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
            this.xStackoneApiSessionToken = xStackoneApiSessionToken;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder format(String format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of((Object)format);
            return this;
        }

        public Builder format(JsonNullable<String> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }

        public Builder exportFormat(String exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = JsonNullable.of((Object)exportFormat);
            return this;
        }

        public Builder exportFormat(JsonNullable<String> exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = exportFormat;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public DocumentsDownloadFileRequest build() {
            return new DocumentsDownloadFileRequest(this.xAccountId, this.xStackoneApiSessionToken, this.id, this.format, this.exportFormat, this.prefer);
        }
    }
}

