/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisCreateEmploymentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisCreateEmployeeEmploymentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto;

    @JsonCreator
    public HrisCreateEmployeeEmploymentRequest(String xAccountId, String id, Optional<String> prefer, HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisCreateEmploymentRequestDto, "hrisCreateEmploymentRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.hrisCreateEmploymentRequestDto = hrisCreateEmploymentRequestDto;
    }

    public HrisCreateEmployeeEmploymentRequest(String xAccountId, String id, HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto) {
        this(xAccountId, id, Optional.empty(), hrisCreateEmploymentRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto() {
        return this.hrisCreateEmploymentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisCreateEmployeeEmploymentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisCreateEmployeeEmploymentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisCreateEmployeeEmploymentRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisCreateEmployeeEmploymentRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisCreateEmployeeEmploymentRequest withHrisCreateEmploymentRequestDto(HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto) {
        Utils.checkNotNull(hrisCreateEmploymentRequestDto, "hrisCreateEmploymentRequestDto");
        this.hrisCreateEmploymentRequestDto = hrisCreateEmploymentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisCreateEmployeeEmploymentRequest other = (HrisCreateEmployeeEmploymentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisCreateEmploymentRequestDto, other.hrisCreateEmploymentRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.hrisCreateEmploymentRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisCreateEmployeeEmploymentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "hrisCreateEmploymentRequestDto", this.hrisCreateEmploymentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisCreateEmploymentRequestDto(HrisCreateEmploymentRequestDto hrisCreateEmploymentRequestDto) {
            Utils.checkNotNull(hrisCreateEmploymentRequestDto, "hrisCreateEmploymentRequestDto");
            this.hrisCreateEmploymentRequestDto = hrisCreateEmploymentRequestDto;
            return this;
        }

        public HrisCreateEmployeeEmploymentRequest build() {
            return new HrisCreateEmployeeEmploymentRequest(this.xAccountId, this.id, this.prefer, this.hrisCreateEmploymentRequestDto);
        }
    }
}

