/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateContentBlocksRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MarketingCreateContentBlockRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

    @JsonCreator
    public MarketingCreateContentBlockRequest(String xAccountId, Optional<String> prefer, MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
    }

    public MarketingCreateContentBlockRequest(String xAccountId, MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        this(xAccountId, Optional.empty(), marketingCreateContentBlocksRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto() {
        return this.marketingCreateContentBlocksRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingCreateContentBlockRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingCreateContentBlockRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MarketingCreateContentBlockRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingCreateContentBlockRequest withMarketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateContentBlockRequest other = (MarketingCreateContentBlockRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.marketingCreateContentBlocksRequestDto, other.marketingCreateContentBlocksRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.marketingCreateContentBlocksRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingCreateContentBlockRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "marketingCreateContentBlocksRequestDto", this.marketingCreateContentBlocksRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder marketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
            Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
            this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
            return this;
        }

        public MarketingCreateContentBlockRequest build() {
            return new MarketingCreateContentBlockRequest(this.xAccountId, this.prefer, this.marketingCreateContentBlocksRequestDto);
        }
    }
}

