/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreatePushTemplateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MarketingUpdatePushTemplateRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto;

    @JsonCreator
    public MarketingUpdatePushTemplateRequest(String xAccountId, String id, Optional<String> prefer, MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
    }

    public MarketingUpdatePushTemplateRequest(String xAccountId, String id, MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        this(xAccountId, id, Optional.empty(), marketingCreatePushTemplateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto() {
        return this.marketingCreatePushTemplateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingUpdatePushTemplateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingUpdatePushTemplateRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MarketingUpdatePushTemplateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MarketingUpdatePushTemplateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MarketingUpdatePushTemplateRequest withMarketingCreatePushTemplateRequestDto(MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
        Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
        this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingUpdatePushTemplateRequest other = (MarketingUpdatePushTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.marketingCreatePushTemplateRequestDto, other.marketingCreatePushTemplateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.marketingCreatePushTemplateRequestDto);
    }

    public String toString() {
        return Utils.toString(MarketingUpdatePushTemplateRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "marketingCreatePushTemplateRequestDto", this.marketingCreatePushTemplateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder marketingCreatePushTemplateRequestDto(MarketingCreatePushTemplateRequestDto marketingCreatePushTemplateRequestDto) {
            Utils.checkNotNull(marketingCreatePushTemplateRequestDto, "marketingCreatePushTemplateRequestDto");
            this.marketingCreatePushTemplateRequestDto = marketingCreatePushTemplateRequestDto;
            return this;
        }

        public MarketingUpdatePushTemplateRequest build() {
            return new MarketingUpdatePushTemplateRequest(this.xAccountId, this.id, this.prefer, this.marketingCreatePushTemplateRequestDto);
        }
    }
}

