/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingCreateConversationRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class MessagingCreateConversationRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private MessagingCreateConversationRequestDto messagingCreateConversationRequestDto;

    @JsonCreator
    public MessagingCreateConversationRequest(String xAccountId, Optional<String> prefer, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
    }

    public MessagingCreateConversationRequest(String xAccountId, MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        this(xAccountId, Optional.empty(), messagingCreateConversationRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public MessagingCreateConversationRequestDto messagingCreateConversationRequestDto() {
        return this.messagingCreateConversationRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingCreateConversationRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MessagingCreateConversationRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public MessagingCreateConversationRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MessagingCreateConversationRequest withMessagingCreateConversationRequestDto(MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
        Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
        this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingCreateConversationRequest other = (MessagingCreateConversationRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.messagingCreateConversationRequestDto, other.messagingCreateConversationRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.messagingCreateConversationRequestDto);
    }

    public String toString() {
        return Utils.toString(MessagingCreateConversationRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "messagingCreateConversationRequestDto", this.messagingCreateConversationRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private MessagingCreateConversationRequestDto messagingCreateConversationRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder messagingCreateConversationRequestDto(MessagingCreateConversationRequestDto messagingCreateConversationRequestDto) {
            Utils.checkNotNull(messagingCreateConversationRequestDto, "messagingCreateConversationRequestDto");
            this.messagingCreateConversationRequestDto = messagingCreateConversationRequestDto;
            return this;
        }

        public MessagingCreateConversationRequest build() {
            return new MessagingCreateConversationRequest(this.xAccountId, this.prefer, this.messagingCreateConversationRequestDto);
        }
    }
}

