/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.stackone.stackone_client_java.utils.CopiableInputStream;
import com.stackone.stackone_client_java.utils.ResponseWithBody;
import com.stackone.stackone_client_java.utils.SpeakeasyLogger;
import com.stackone.stackone_client_java.utils.pagination.ProgressTrackerStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Paginator<ReqT, ProgressParamT>
implements Iterator<HttpResponse<InputStream>> {
    private static final SpeakeasyLogger logger = SpeakeasyLogger.getLogger(Paginator.class);
    private final ReqT initialRequest;
    private final ProgressTrackerStrategy<ProgressParamT> progressTracker;
    private final BiFunction<ReqT, ProgressParamT, ReqT> requestModifier;
    private final Function<ReqT, HttpResponse<InputStream>> dataFetcher;
    private static final Configuration JSON_PATH_CONFIG = Configuration.defaultConfiguration().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
    private PaginationState state = PaginationState.INITIAL;
    private HttpResponse<InputStream> currentResponse = null;

    public Paginator(ReqT initialRequest, ProgressTrackerStrategy<ProgressParamT> progressTracker, BiFunction<ReqT, ProgressParamT, ReqT> requestModifier, Function<ReqT, HttpResponse<InputStream>> dataFetcher) {
        this.initialRequest = initialRequest;
        this.progressTracker = progressTracker;
        this.requestModifier = requestModifier;
        this.dataFetcher = dataFetcher;
    }

    public Optional<HttpResponse<InputStream>> currentResponse() {
        return Optional.ofNullable(this.currentResponse);
    }

    @Override
    public boolean hasNext() {
        if (this.currentResponse != null) {
            return true;
        }
        if (this.state != PaginationState.EXHAUSTED) {
            this.fetchNext();
        }
        return this.currentResponse != null;
    }

    private void fetchNext() {
        ReqT request;
        ProgressParamT currentValue = this.progressTracker.getPosition();
        ReqT ReqT = request = this.state == PaginationState.INITIAL ? this.initialRequest : this.requestModifier.apply(this.initialRequest, currentValue);
        if (this.state == PaginationState.INITIAL) {
            logger.debug("Fetching initial page");
        } else {
            logger.debug("Fetching next page with position: {}", (Object)currentValue);
        }
        HttpResponse<InputStream> response = this.dataFetcher.apply(request);
        try (InputStream body = response.body();){
            CopiableInputStream copiableInputStream = new CopiableInputStream(body);
            DocumentContext respJson = JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(copiableInputStream.copy());
            this.currentResponse = new ResponseWithBody<InputStream, Function<InputStream, InputStream>>(response, given -> copiableInputStream.copy());
            boolean hasMorePages = this.progressTracker.advance((ReadContext)respJson);
            PaginationState paginationState = this.state = hasMorePages ? PaginationState.HAS_MORE_PAGES : PaginationState.EXHAUSTED;
            if (logger.isTraceEnabled()) {
                logger.trace("Page fetched - status: {}, hasMorePages: {}", (Object)response.statusCode(), (Object)hasMorePages);
            }
        }
        catch (IOException e) {
            logger.debug("Error fetching page: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpResponse<InputStream> next() {
        HttpResponse<InputStream> response = this.currentResponse().orElseThrow(() -> new IllegalStateException("No more pages available"));
        this.currentResponse = null;
        return response;
    }

    private static enum PaginationState {
        INITIAL,
        HAS_MORE_PAGES,
        EXHAUSTED;

    }
}

