/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.AccountResult;
import com.stackone.stackone_client_java.models.components.AccountsPaginated;
import com.stackone.stackone_client_java.models.components.ContactResult;
import com.stackone.stackone_client_java.models.components.ContactsPaginated;
import com.stackone.stackone_client_java.models.components.CrmCreateContactRequestDto;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionResultApiModel;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionsPaginated;
import com.stackone.stackone_client_java.models.components.ListResult;
import com.stackone.stackone_client_java.models.components.ListsPaginated;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmCreateContactResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetAccountResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetContactCustomFieldDefinitionResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetContactResponse;
import com.stackone.stackone_client_java.models.operations.CrmGetListRequest;
import com.stackone.stackone_client_java.models.operations.CrmGetListRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmGetListResponse;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListAccountsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListContactCustomFieldDefinitionsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListContactsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListContactsResponse;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmListListsResponse;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactRequest;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactRequestBuilder;
import com.stackone.stackone_client_java.models.operations.CrmUpdateContactResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SerializedBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openapitools.jackson.nullable.JsonNullable;

public class Crm
implements SDKMethodInterfaces.MethodCallCrmListContacts,
SDKMethodInterfaces.MethodCallCrmCreateContact,
SDKMethodInterfaces.MethodCallCrmGetContact,
SDKMethodInterfaces.MethodCallCrmUpdateContact,
SDKMethodInterfaces.MethodCallCrmListAccounts,
SDKMethodInterfaces.MethodCallCrmGetAccount,
SDKMethodInterfaces.MethodCallCrmListLists,
SDKMethodInterfaces.MethodCallCrmGetList,
SDKMethodInterfaces.MethodCallCrmListContactCustomFieldDefinitions,
SDKMethodInterfaces.MethodCallCrmGetContactCustomFieldDefinition {
    private final SDKConfiguration sdkConfiguration;

    Crm(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CrmListContactsRequestBuilder listContacts() {
        return new CrmListContactsRequestBuilder(this);
    }

    public CrmListContactsResponse listContacts(CrmListContactsRequest request) throws Exception {
        return this.listContacts(request, Optional.empty());
    }

    @Override
    public CrmListContactsResponse listContacts(CrmListContactsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/crm/contacts");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmListContactsRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_list_contacts", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_list_contacts", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_list_contacts", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        CrmListContactsResponse.Builder _resBuilder = CrmListContactsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            if (request == null) {
                return Optional.empty();
            }
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            Configuration _config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            DocumentContext _body = JsonPath.using((Configuration)_config).parse(_stringBody);
            String _nextCursor = (String)_body.read("$.next", String.class, new Predicate[0]);
            if (_nextCursor == null) {
                return Optional.empty();
            }
            CrmListContactsRequestBuilder _ret = this.listContacts();
            _ret.request(new CrmListContactsRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), (JsonNullable<String>)JsonNullable.of((Object)_nextCursor), request.updatedAfter(), request.include()));
            return Optional.of(_ret.call());
        });
        CrmListContactsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ContactsPaginated _out = (ContactsPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<ContactsPaginated>(){});
                _res.withContactsPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public CrmCreateContactRequestBuilder createContact() {
        return new CrmCreateContactRequestBuilder(this);
    }

    public CrmCreateContactResponse createContact(String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto) throws Exception {
        return this.createContact(xAccountId, crmCreateContactRequestDto, Optional.empty());
    }

    @Override
    public CrmCreateContactResponse createContact(String xAccountId, CrmCreateContactRequestDto crmCreateContactRequestDto, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CrmCreateContactRequest request = CrmCreateContactRequest.builder().xAccountId(xAccountId).crmCreateContactRequestDto(crmCreateContactRequestDto).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/crm/contacts");
        HTTPRequest _req = new HTTPRequest(_url, "POST");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "crmCreateContactRequestDto", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_create_contact", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_create_contact", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_create_contact", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmCreateContactResponse.Builder _resBuilder = CrmCreateContactResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmCreateContactResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ContactResult _out = (ContactResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ContactResult>(){});
                _res.withContactResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CrmGetContactRequestBuilder getContact() {
        return new CrmGetContactRequestBuilder(this);
    }

    public CrmGetContactResponse getContact(CrmGetContactRequest request) throws Exception {
        return this.getContact(request, Optional.empty());
    }

    @Override
    public CrmGetContactResponse getContact(CrmGetContactRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CrmGetContactRequest.class, _baseUrl, "/unified/crm/contacts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmGetContactRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_get_contact", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_get_contact", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_get_contact", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmGetContactResponse.Builder _resBuilder = CrmGetContactResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmGetContactResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ContactResult _out = (ContactResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ContactResult>(){});
                _res.withContactResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CrmUpdateContactRequestBuilder updateContact() {
        return new CrmUpdateContactRequestBuilder(this);
    }

    public CrmUpdateContactResponse updateContact(String xAccountId, String id, CrmCreateContactRequestDto crmCreateContactRequestDto) throws Exception {
        return this.updateContact(xAccountId, id, crmCreateContactRequestDto, Optional.empty());
    }

    @Override
    public CrmUpdateContactResponse updateContact(String xAccountId, String id, CrmCreateContactRequestDto crmCreateContactRequestDto, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        CrmUpdateContactRequest request = CrmUpdateContactRequest.builder().xAccountId(xAccountId).id(id).crmCreateContactRequestDto(crmCreateContactRequestDto).build();
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CrmUpdateContactRequest.class, _baseUrl, "/unified/crm/contacts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "PATCH");
        Object _convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody _serializedRequestBody = Utils.serializeRequestBody(_convertedRequest, "crmCreateContactRequestDto", "json", false);
        if (_serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        _req.setBody(Optional.ofNullable(_serializedRequestBody));
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_update_contact", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_update_contact", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_update_contact", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmUpdateContactResponse.Builder _resBuilder = CrmUpdateContactResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmUpdateContactResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ContactResult _out = (ContactResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ContactResult>(){});
                _res.withContactResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CrmListAccountsRequestBuilder listAccounts() {
        return new CrmListAccountsRequestBuilder(this);
    }

    public CrmListAccountsResponse listAccounts(CrmListAccountsRequest request) throws Exception {
        return this.listAccounts(request, Optional.empty());
    }

    @Override
    public CrmListAccountsResponse listAccounts(CrmListAccountsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/crm/accounts");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmListAccountsRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_list_accounts", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_list_accounts", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_list_accounts", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        CrmListAccountsResponse.Builder _resBuilder = CrmListAccountsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            if (request == null) {
                return Optional.empty();
            }
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            Configuration _config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            DocumentContext _body = JsonPath.using((Configuration)_config).parse(_stringBody);
            String _nextCursor = (String)_body.read("$.next", String.class, new Predicate[0]);
            if (_nextCursor == null) {
                return Optional.empty();
            }
            CrmListAccountsRequestBuilder _ret = this.listAccounts();
            _ret.request(new CrmListAccountsRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), (JsonNullable<String>)JsonNullable.of((Object)_nextCursor), request.updatedAfter()));
            return Optional.of(_ret.call());
        });
        CrmListAccountsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AccountsPaginated _out = (AccountsPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<AccountsPaginated>(){});
                _res.withAccountsPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public CrmGetAccountRequestBuilder getAccount() {
        return new CrmGetAccountRequestBuilder(this);
    }

    public CrmGetAccountResponse getAccount(CrmGetAccountRequest request) throws Exception {
        return this.getAccount(request, Optional.empty());
    }

    @Override
    public CrmGetAccountResponse getAccount(CrmGetAccountRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CrmGetAccountRequest.class, _baseUrl, "/unified/crm/accounts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmGetAccountRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_get_account", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_get_account", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_get_account", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmGetAccountResponse.Builder _resBuilder = CrmGetAccountResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmGetAccountResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                AccountResult _out = (AccountResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<AccountResult>(){});
                _res.withAccountResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CrmListListsRequestBuilder listLists() {
        return new CrmListListsRequestBuilder(this);
    }

    public CrmListListsResponse listLists(CrmListListsRequest request) throws Exception {
        return this.listLists(request, Optional.empty());
    }

    @Override
    public CrmListListsResponse listLists(CrmListListsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/crm/lists");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmListListsRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_list_lists", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_list_lists", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_list_lists", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        CrmListListsResponse.Builder _resBuilder = CrmListListsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            if (request == null) {
                return Optional.empty();
            }
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            Configuration _config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            DocumentContext _body = JsonPath.using((Configuration)_config).parse(_stringBody);
            String _nextCursor = (String)_body.read("$.next", String.class, new Predicate[0]);
            if (_nextCursor == null) {
                return Optional.empty();
            }
            CrmListListsRequestBuilder _ret = this.listLists();
            _ret.request(new CrmListListsRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), (JsonNullable<String>)JsonNullable.of((Object)_nextCursor), request.updatedAfter()));
            return Optional.of(_ret.call());
        });
        CrmListListsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ListsPaginated _out = (ListsPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<ListsPaginated>(){});
                _res.withListsPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public CrmGetListRequestBuilder getList() {
        return new CrmGetListRequestBuilder(this);
    }

    public CrmGetListResponse getList(CrmGetListRequest request) throws Exception {
        return this.getList(request, Optional.empty());
    }

    @Override
    public CrmGetListResponse getList(CrmGetListRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CrmGetListRequest.class, _baseUrl, "/unified/crm/lists/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmGetListRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_get_list", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_get_list", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_get_list", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmGetListResponse.Builder _resBuilder = CrmGetListResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmGetListResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                ListResult _out = (ListResult)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<ListResult>(){});
                _res.withListResult(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }

    public CrmListContactCustomFieldDefinitionsRequestBuilder listContactCustomFieldDefinitions() {
        return new CrmListContactCustomFieldDefinitionsRequestBuilder(this);
    }

    public CrmListContactCustomFieldDefinitionsResponse listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request) throws Exception {
        return this.listContactCustomFieldDefinitions(request, Optional.empty());
    }

    @Override
    public CrmListContactCustomFieldDefinitionsResponse listContactCustomFieldDefinitions(CrmListContactCustomFieldDefinitionsRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(_baseUrl, "/unified/crm/custom_field_definitions/contacts");
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmListContactCustomFieldDefinitionsRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_list_contact_custom_field_definitions", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_list_contact_custom_field_definitions", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_list_contact_custom_field_definitions", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        byte[] _fullResponse = Utils.extractByteArrayFromBody(_httpRes);
        CrmListContactCustomFieldDefinitionsResponse.Builder _resBuilder = CrmListContactCustomFieldDefinitionsResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes).next(() -> {
            if (request == null) {
                return Optional.empty();
            }
            String _stringBody = new String(_fullResponse, StandardCharsets.UTF_8);
            Configuration _config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            DocumentContext _body = JsonPath.using((Configuration)_config).parse(_stringBody);
            String _nextCursor = (String)_body.read("$.next", String.class, new Predicate[0]);
            if (_nextCursor == null) {
                return Optional.empty();
            }
            CrmListContactCustomFieldDefinitionsRequestBuilder _ret = this.listContactCustomFieldDefinitions();
            _ret.request(new CrmListContactCustomFieldDefinitionsRequest(request.xAccountId(), request.raw(), request.proxy(), request.fields(), request.filter(), request.page(), request.pageSize(), (JsonNullable<String>)JsonNullable.of((Object)_nextCursor), request.updatedAfter()));
            return Optional.of(_ret.call());
        });
        CrmListContactCustomFieldDefinitionsResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                CustomFieldDefinitionsPaginated _out = (CustomFieldDefinitionsPaginated)Utils.mapper().readValue(new String(_fullResponse, StandardCharsets.UTF_8), (TypeReference)new TypeReference<CustomFieldDefinitionsPaginated>(){});
                _res.withCustomFieldDefinitionsPaginated(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", _fullResponse);
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), _fullResponse);
    }

    public CrmGetContactCustomFieldDefinitionRequestBuilder getContactCustomFieldDefinition() {
        return new CrmGetContactCustomFieldDefinitionRequestBuilder(this);
    }

    public CrmGetContactCustomFieldDefinitionResponse getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request) throws Exception {
        return this.getContactCustomFieldDefinition(request, Optional.empty());
    }

    @Override
    public CrmGetContactCustomFieldDefinitionResponse getContactCustomFieldDefinition(CrmGetContactCustomFieldDefinitionRequest request, Optional<Options> options) throws Exception {
        if (options.isPresent()) {
            options.get().validate(Arrays.asList(Options.Option.RETRY_CONFIG));
        }
        String _baseUrl = this.sdkConfiguration.serverUrl;
        String _url = Utils.generateURL(CrmGetContactCustomFieldDefinitionRequest.class, _baseUrl, "/unified/crm/custom_field_definitions/contacts/{id}", request, null);
        HTTPRequest _req = new HTTPRequest(_url, "GET");
        _req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        _req.addQueryParams(Utils.getQueryParams(CrmGetContactCustomFieldDefinitionRequest.class, request, null));
        _req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> _hookSecuritySource = this.sdkConfiguration.securitySource();
        Utils.configureSecurity(_req, this.sdkConfiguration.securitySource.getSecurity());
        HTTPClient _client = this.sdkConfiguration.defaultClient;
        HTTPRequest _finalReq = _req;
        RetryConfig _retryConfig = options.isPresent() && options.get().retryConfig().isPresent() ? options.get().retryConfig().get() : (this.sdkConfiguration.retryConfig.isPresent() ? this.sdkConfiguration.retryConfig.get() : RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> _statusCodes = new ArrayList<String>();
        _statusCodes.add("429");
        _statusCodes.add("408");
        Retries _retries = Retries.builder().action(() -> {
            HttpRequest _r = null;
            try {
                _r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl("crm_get_contact_custom_field_definition", Optional.of(List.of()), _hookSecuritySource), _finalReq.build());
            }
            catch (Exception _e) {
                throw new Retries.NonRetryableException(_e);
            }
            try {
                return _client.send(_r);
            }
            catch (Exception _e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl("crm_get_contact_custom_field_definition", Optional.of(List.of()), _hookSecuritySource), Optional.empty(), Optional.of(_e));
            }
        }).retryConfig(_retryConfig).statusCodes(_statusCodes).build();
        HttpResponse<InputStream> _httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl("crm_get_contact_custom_field_definition", Optional.of(List.of()), _hookSecuritySource), _retries.run());
        String _contentType = _httpRes.headers().firstValue("Content-Type").orElse("application/octet-stream");
        CrmGetContactCustomFieldDefinitionResponse.Builder _resBuilder = CrmGetContactCustomFieldDefinitionResponse.builder().contentType(_contentType).statusCode(_httpRes.statusCode()).rawResponse(_httpRes);
        CrmGetContactCustomFieldDefinitionResponse _res = _resBuilder.build();
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "200")) {
            if (Utils.contentTypeMatches(_contentType, "application/json")) {
                CustomFieldDefinitionResultApiModel _out = (CustomFieldDefinitionResultApiModel)Utils.mapper().readValue(Utils.toUtf8AndClose(_httpRes.body()), (TypeReference)new TypeReference<CustomFieldDefinitionResultApiModel>(){});
                _res.withCustomFieldDefinitionResultApiModel(Optional.ofNullable(_out));
                return _res;
            }
            throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected content-type received: " + _contentType, Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "408")) {
            _res.withHeaders(_httpRes.headers().map());
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "400", "403", "412", "429", "4XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        if (Utils.statusCodeMatches(_httpRes.statusCode(), "500", "501", "5XX")) {
            throw new SDKError(_httpRes, _httpRes.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(_httpRes));
        }
        throw new SDKError(_httpRes, _httpRes.statusCode(), "Unexpected status code received: " + _httpRes.statusCode(), Utils.extractByteArrayFromBody(_httpRes));
    }
}

