/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsDocumentResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsGetApplicationDocumentResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AtsDocumentResult> atsDocumentResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AtsDocumentResult> atsDocumentResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsDocumentResult = atsDocumentResult;
        this.headers = headers;
    }

    public AtsGetApplicationDocumentResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AtsDocumentResult> atsDocumentResult() {
        return this.atsDocumentResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetApplicationDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetApplicationDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetApplicationDocumentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetApplicationDocumentResponse withAtsDocumentResult(AtsDocumentResult atsDocumentResult) {
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        this.atsDocumentResult = Optional.ofNullable(atsDocumentResult);
        return this;
    }

    public AtsGetApplicationDocumentResponse withAtsDocumentResult(Optional<? extends AtsDocumentResult> atsDocumentResult) {
        Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
        this.atsDocumentResult = atsDocumentResult;
        return this;
    }

    public AtsGetApplicationDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetApplicationDocumentResponse other = (AtsGetApplicationDocumentResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.atsDocumentResult, other.atsDocumentResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.atsDocumentResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetApplicationDocumentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsDocumentResult", this.atsDocumentResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AtsDocumentResult> atsDocumentResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsDocumentResult(AtsDocumentResult atsDocumentResult) {
            Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
            this.atsDocumentResult = Optional.ofNullable(atsDocumentResult);
            return this;
        }

        public Builder atsDocumentResult(Optional<? extends AtsDocumentResult> atsDocumentResult) {
            Utils.checkNotNull(atsDocumentResult, "atsDocumentResult");
            this.atsDocumentResult = atsDocumentResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetApplicationDocumentResponse build() {
            return new AtsGetApplicationDocumentResponse(this.contentType, this.statusCode, this.rawResponse, this.atsDocumentResult, this.headers);
        }
    }
}

