/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LinkedAccount;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StackoneUpdateAccountResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends LinkedAccount> linkedAccount;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneUpdateAccountResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends LinkedAccount> linkedAccount, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(linkedAccount, "linkedAccount");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.linkedAccount = linkedAccount;
        this.headers = headers;
    }

    public StackoneUpdateAccountResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<LinkedAccount> linkedAccount() {
        return this.linkedAccount;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public StackoneUpdateAccountResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneUpdateAccountResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneUpdateAccountResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneUpdateAccountResponse withLinkedAccount(LinkedAccount linkedAccount) {
        Utils.checkNotNull(linkedAccount, "linkedAccount");
        this.linkedAccount = Optional.ofNullable(linkedAccount);
        return this;
    }

    public StackoneUpdateAccountResponse withLinkedAccount(Optional<? extends LinkedAccount> linkedAccount) {
        Utils.checkNotNull(linkedAccount, "linkedAccount");
        this.linkedAccount = linkedAccount;
        return this;
    }

    public StackoneUpdateAccountResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneUpdateAccountResponse other = (StackoneUpdateAccountResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.linkedAccount, other.linkedAccount) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.linkedAccount, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneUpdateAccountResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "linkedAccount", this.linkedAccount, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends LinkedAccount> linkedAccount = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder linkedAccount(LinkedAccount linkedAccount) {
            Utils.checkNotNull(linkedAccount, "linkedAccount");
            this.linkedAccount = Optional.ofNullable(linkedAccount);
            return this;
        }

        public Builder linkedAccount(Optional<? extends LinkedAccount> linkedAccount) {
            Utils.checkNotNull(linkedAccount, "linkedAccount");
            this.linkedAccount = linkedAccount;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneUpdateAccountResponse build() {
            return new StackoneUpdateAccountResponse(this.contentType, this.statusCode, this.rawResponse, this.linkedAccount, this.headers);
        }
    }
}

