/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class AssessmentResult {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate")
    private JsonNullable<? extends AssessmentResultCandidate> candidate;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("score")
    private JsonNullable<? extends AssessmentResultScore> score;

    /**
     * The start date of the candidate test
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * The submission date of the candidate test
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("submission_date")
    private JsonNullable<OffsetDateTime> submissionDate;

    /**
     * The summary about the result of the test
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("summary")
    private JsonNullable<String> summary;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result")
    private JsonNullable<? extends AssessmentResultResult> result;

    /**
     * The test`s result url
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("result_url")
    private JsonNullable<String> resultUrl;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attachments")
    private JsonNullable<? extends List<Attachment>> attachments;

    @JsonCreator
    public AssessmentResult(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("candidate") JsonNullable<? extends AssessmentResultCandidate> candidate,
            @JsonProperty("score") JsonNullable<? extends AssessmentResultScore> score,
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("submission_date") JsonNullable<OffsetDateTime> submissionDate,
            @JsonProperty("summary") JsonNullable<String> summary,
            @JsonProperty("result") JsonNullable<? extends AssessmentResultResult> result,
            @JsonProperty("result_url") JsonNullable<String> resultUrl,
            @JsonProperty("attachments") JsonNullable<? extends List<Attachment>> attachments) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(candidate, "candidate");
        Utils.checkNotNull(score, "score");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(submissionDate, "submissionDate");
        Utils.checkNotNull(summary, "summary");
        Utils.checkNotNull(result, "result");
        Utils.checkNotNull(resultUrl, "resultUrl");
        Utils.checkNotNull(attachments, "attachments");
        this.id = id;
        this.remoteId = remoteId;
        this.candidate = candidate;
        this.score = score;
        this.startDate = startDate;
        this.submissionDate = submissionDate;
        this.summary = summary;
        this.result = result;
        this.resultUrl = resultUrl;
        this.attachments = attachments;
    }
    
    public AssessmentResult() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssessmentResultCandidate> candidate() {
        return (JsonNullable<AssessmentResultCandidate>) candidate;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssessmentResultScore> score() {
        return (JsonNullable<AssessmentResultScore>) score;
    }

    /**
     * The start date of the candidate test
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * The submission date of the candidate test
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> submissionDate() {
        return submissionDate;
    }

    /**
     * The summary about the result of the test
     */
    @JsonIgnore
    public JsonNullable<String> summary() {
        return summary;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssessmentResultResult> result() {
        return (JsonNullable<AssessmentResultResult>) result;
    }

    /**
     * The test`s result url
     */
    @JsonIgnore
    public JsonNullable<String> resultUrl() {
        return resultUrl;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Attachment>> attachments() {
        return (JsonNullable<List<Attachment>>) attachments;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public AssessmentResult withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AssessmentResult withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AssessmentResult withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AssessmentResult withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public AssessmentResult withCandidate(AssessmentResultCandidate candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = JsonNullable.of(candidate);
        return this;
    }

    public AssessmentResult withCandidate(JsonNullable<? extends AssessmentResultCandidate> candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = candidate;
        return this;
    }

    public AssessmentResult withScore(AssessmentResultScore score) {
        Utils.checkNotNull(score, "score");
        this.score = JsonNullable.of(score);
        return this;
    }

    public AssessmentResult withScore(JsonNullable<? extends AssessmentResultScore> score) {
        Utils.checkNotNull(score, "score");
        this.score = score;
        return this;
    }

    /**
     * The start date of the candidate test
     */
    public AssessmentResult withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * The start date of the candidate test
     */
    public AssessmentResult withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * The submission date of the candidate test
     */
    public AssessmentResult withSubmissionDate(OffsetDateTime submissionDate) {
        Utils.checkNotNull(submissionDate, "submissionDate");
        this.submissionDate = JsonNullable.of(submissionDate);
        return this;
    }

    /**
     * The submission date of the candidate test
     */
    public AssessmentResult withSubmissionDate(JsonNullable<OffsetDateTime> submissionDate) {
        Utils.checkNotNull(submissionDate, "submissionDate");
        this.submissionDate = submissionDate;
        return this;
    }

    /**
     * The summary about the result of the test
     */
    public AssessmentResult withSummary(String summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = JsonNullable.of(summary);
        return this;
    }

    /**
     * The summary about the result of the test
     */
    public AssessmentResult withSummary(JsonNullable<String> summary) {
        Utils.checkNotNull(summary, "summary");
        this.summary = summary;
        return this;
    }

    public AssessmentResult withResult(AssessmentResultResult result) {
        Utils.checkNotNull(result, "result");
        this.result = JsonNullable.of(result);
        return this;
    }

    public AssessmentResult withResult(JsonNullable<? extends AssessmentResultResult> result) {
        Utils.checkNotNull(result, "result");
        this.result = result;
        return this;
    }

    /**
     * The test`s result url
     */
    public AssessmentResult withResultUrl(String resultUrl) {
        Utils.checkNotNull(resultUrl, "resultUrl");
        this.resultUrl = JsonNullable.of(resultUrl);
        return this;
    }

    /**
     * The test`s result url
     */
    public AssessmentResult withResultUrl(JsonNullable<String> resultUrl) {
        Utils.checkNotNull(resultUrl, "resultUrl");
        this.resultUrl = resultUrl;
        return this;
    }

    public AssessmentResult withAttachments(List<Attachment> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = JsonNullable.of(attachments);
        return this;
    }

    public AssessmentResult withAttachments(JsonNullable<? extends List<Attachment>> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AssessmentResult other = (AssessmentResult) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.candidate, other.candidate) &&
            Utils.enhancedDeepEquals(this.score, other.score) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.submissionDate, other.submissionDate) &&
            Utils.enhancedDeepEquals(this.summary, other.summary) &&
            Utils.enhancedDeepEquals(this.result, other.result) &&
            Utils.enhancedDeepEquals(this.resultUrl, other.resultUrl) &&
            Utils.enhancedDeepEquals(this.attachments, other.attachments);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            candidate,
            score,
            startDate,
            submissionDate,
            summary,
            result,
            resultUrl,
            attachments);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AssessmentResult.class,
                "id", id,
                "remoteId", remoteId,
                "candidate", candidate,
                "score", score,
                "startDate", startDate,
                "submissionDate", submissionDate,
                "summary", summary,
                "result", result,
                "resultUrl", resultUrl,
                "attachments", attachments);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends AssessmentResultCandidate> candidate = JsonNullable.undefined();
 
        private JsonNullable<? extends AssessmentResultScore> score = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> submissionDate = JsonNullable.undefined();
 
        private JsonNullable<String> summary = JsonNullable.undefined();
 
        private JsonNullable<? extends AssessmentResultResult> result = JsonNullable.undefined();
 
        private JsonNullable<String> resultUrl = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Attachment>> attachments = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder candidate(AssessmentResultCandidate candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = JsonNullable.of(candidate);
            return this;
        }

        public Builder candidate(JsonNullable<? extends AssessmentResultCandidate> candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = candidate;
            return this;
        }

        public Builder score(AssessmentResultScore score) {
            Utils.checkNotNull(score, "score");
            this.score = JsonNullable.of(score);
            return this;
        }

        public Builder score(JsonNullable<? extends AssessmentResultScore> score) {
            Utils.checkNotNull(score, "score");
            this.score = score;
            return this;
        }

        /**
         * The start date of the candidate test
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * The start date of the candidate test
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }

        /**
         * The submission date of the candidate test
         */
        public Builder submissionDate(OffsetDateTime submissionDate) {
            Utils.checkNotNull(submissionDate, "submissionDate");
            this.submissionDate = JsonNullable.of(submissionDate);
            return this;
        }

        /**
         * The submission date of the candidate test
         */
        public Builder submissionDate(JsonNullable<OffsetDateTime> submissionDate) {
            Utils.checkNotNull(submissionDate, "submissionDate");
            this.submissionDate = submissionDate;
            return this;
        }

        /**
         * The summary about the result of the test
         */
        public Builder summary(String summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = JsonNullable.of(summary);
            return this;
        }

        /**
         * The summary about the result of the test
         */
        public Builder summary(JsonNullable<String> summary) {
            Utils.checkNotNull(summary, "summary");
            this.summary = summary;
            return this;
        }

        public Builder result(AssessmentResultResult result) {
            Utils.checkNotNull(result, "result");
            this.result = JsonNullable.of(result);
            return this;
        }

        public Builder result(JsonNullable<? extends AssessmentResultResult> result) {
            Utils.checkNotNull(result, "result");
            this.result = result;
            return this;
        }

        /**
         * The test`s result url
         */
        public Builder resultUrl(String resultUrl) {
            Utils.checkNotNull(resultUrl, "resultUrl");
            this.resultUrl = JsonNullable.of(resultUrl);
            return this;
        }

        /**
         * The test`s result url
         */
        public Builder resultUrl(JsonNullable<String> resultUrl) {
            Utils.checkNotNull(resultUrl, "resultUrl");
            this.resultUrl = resultUrl;
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = JsonNullable.of(attachments);
            return this;
        }

        public Builder attachments(JsonNullable<? extends List<Attachment>> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }
        
        public AssessmentResult build() {
            return new AssessmentResult(
                id,
                remoteId,
                candidate,
                score,
                startDate,
                submissionDate,
                summary,
                result,
                resultUrl,
                attachments);
        }
    }
}
