/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class InAppMessagesMessageType {

    /**
     * The unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends InAppMessagesValue> value;

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends InAppMessagesSourceValue> sourceValue;

    @JsonCreator
    public InAppMessagesMessageType(
            @JsonProperty("value") JsonNullable<? extends InAppMessagesValue> value,
            @JsonProperty("source_value") JsonNullable<? extends InAppMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public InAppMessagesMessageType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InAppMessagesValue> value() {
        return (JsonNullable<InAppMessagesValue>) value;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InAppMessagesSourceValue> sourceValue() {
        return (JsonNullable<InAppMessagesSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified message type.
     */
    public InAppMessagesMessageType withValue(InAppMessagesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified message type.
     */
    public InAppMessagesMessageType withValue(JsonNullable<? extends InAppMessagesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public InAppMessagesMessageType withSourceValue(InAppMessagesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public InAppMessagesMessageType withSourceValue(JsonNullable<? extends InAppMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InAppMessagesMessageType other = (InAppMessagesMessageType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InAppMessagesMessageType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends InAppMessagesValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends InAppMessagesSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified message type.
         */
        public Builder value(InAppMessagesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified message type.
         */
        public Builder value(JsonNullable<? extends InAppMessagesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(InAppMessagesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(JsonNullable<? extends InAppMessagesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public InAppMessagesMessageType build() {
            return new InAppMessagesMessageType(
                value,
                sourceValue);
        }
    }
}
