/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * ListType
 * 
 * <p>The list type
 */
public class ListType {

    /**
     * The type of the list.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ListValue> value;

    /**
     * The source value of the list type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ListSourceValue> sourceValue;

    @JsonCreator
    public ListType(
            @JsonProperty("value") JsonNullable<? extends ListValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ListSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ListType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the list.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ListValue> value() {
        return (JsonNullable<ListValue>) value;
    }

    /**
     * The source value of the list type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ListSourceValue> sourceValue() {
        return (JsonNullable<ListSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of the list.
     */
    public ListType withValue(ListValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the list.
     */
    public ListType withValue(JsonNullable<? extends ListValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the list type.
     */
    public ListType withSourceValue(ListSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the list type.
     */
    public ListType withSourceValue(JsonNullable<? extends ListSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListType other = (ListType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends ListValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends ListSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the list.
         */
        public Builder value(ListValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the list.
         */
        public Builder value(JsonNullable<? extends ListValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the list type.
         */
        public Builder sourceValue(ListSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the list type.
         */
        public Builder sourceValue(JsonNullable<? extends ListSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public ListType build() {
            return new ListType(
                value,
                sourceValue);
        }
    }
}
