/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.IamUsersPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IamListUsersResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The list of users was retrieved.
     */
    private Optional<? extends IamUsersPaginated> iamUsersPaginated;

    private Map<String, List<String>> headers;

    @JsonCreator
    public IamListUsersResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends IamUsersPaginated> iamUsersPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.iamUsersPaginated = iamUsersPaginated;
        this.headers = headers;
    }
    
    public IamListUsersResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of users was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<IamUsersPaginated> iamUsersPaginated() {
        return (Optional<IamUsersPaginated>) iamUsersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public IamListUsersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public IamListUsersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public IamListUsersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of users was retrieved.
     */
    public IamListUsersResponse withIamUsersPaginated(IamUsersPaginated iamUsersPaginated) {
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        this.iamUsersPaginated = Optional.ofNullable(iamUsersPaginated);
        return this;
    }

    /**
     * The list of users was retrieved.
     */
    public IamListUsersResponse withIamUsersPaginated(Optional<? extends IamUsersPaginated> iamUsersPaginated) {
        Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
        this.iamUsersPaginated = iamUsersPaginated;
        return this;
    }

    public IamListUsersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamListUsersResponse other = (IamListUsersResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.iamUsersPaginated, other.iamUsersPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType,
            statusCode,
            rawResponse,
            iamUsersPaginated,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamListUsersResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "iamUsersPaginated", iamUsersPaginated,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends IamUsersPaginated> iamUsersPaginated = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The list of users was retrieved.
         */
        public Builder iamUsersPaginated(IamUsersPaginated iamUsersPaginated) {
            Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
            this.iamUsersPaginated = Optional.ofNullable(iamUsersPaginated);
            return this;
        }

        /**
         * The list of users was retrieved.
         */
        public Builder iamUsersPaginated(Optional<? extends IamUsersPaginated> iamUsersPaginated) {
            Utils.checkNotNull(iamUsersPaginated, "iamUsersPaginated");
            this.iamUsersPaginated = iamUsersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public IamListUsersResponse build() {
            return new IamListUsersResponse(
                contentType,
                statusCode,
                rawResponse,
                iamUsersPaginated,
                headers);
        }
    }
}
