/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class Assignment {
    /**
     * The ID associated with this assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    @Deprecated
    private JsonNullable<String> externalReference;

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_id")
    private JsonNullable<String> learningObjectId;

    /**
     * Provider's unique identifier of the learning object related to the assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_learning_object_id")
    private JsonNullable<String> remoteLearningObjectId;

    /**
     * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_external_reference")
    private JsonNullable<String> learningObjectExternalReference;

    /**
     * The progress associated with this assigment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("progress")
    private JsonNullable<Double> progress;

    /**
     * The date the assignment was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The date the assignment was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The date the assignment is due to be completed
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("due_date")
    private JsonNullable<OffsetDateTime> dueDate;

    /**
     * The status of the assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends AssignmentStatus> status;

    /**
     * The learning object type of the assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_type")
    private JsonNullable<? extends LearningObjectType> learningObjectType;

    /**
     * The user ID associated with this assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("user_id")
    private JsonNullable<String> userId;

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_user_id")
    private JsonNullable<String> remoteUserId;

    /**
     * The course ID associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("course_id")
    @Deprecated
    private JsonNullable<String> courseId;

    /**
     * Provider's unique identifier of the course related to the assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_course_id")
    @Deprecated
    private JsonNullable<String> remoteCourseId;

    @JsonCreator
    public Assignment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("learning_object_id") JsonNullable<String> learningObjectId,
            @JsonProperty("remote_learning_object_id") JsonNullable<String> remoteLearningObjectId,
            @JsonProperty("learning_object_external_reference") JsonNullable<String> learningObjectExternalReference,
            @JsonProperty("progress") JsonNullable<Double> progress,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("due_date") JsonNullable<OffsetDateTime> dueDate,
            @JsonProperty("status") JsonNullable<? extends AssignmentStatus> status,
            @JsonProperty("learning_object_type") JsonNullable<? extends LearningObjectType> learningObjectType,
            @JsonProperty("user_id") JsonNullable<String> userId,
            @JsonProperty("remote_user_id") JsonNullable<String> remoteUserId,
            @JsonProperty("course_id") JsonNullable<String> courseId,
            @JsonProperty("remote_course_id") JsonNullable<String> remoteCourseId) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        Utils.checkNotNull(progress, "progress");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(dueDate, "dueDate");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        Utils.checkNotNull(courseId, "courseId");
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.externalReference = externalReference;
        this.learningObjectId = learningObjectId;
        this.remoteLearningObjectId = remoteLearningObjectId;
        this.learningObjectExternalReference = learningObjectExternalReference;
        this.progress = progress;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
        this.dueDate = dueDate;
        this.status = status;
        this.learningObjectType = learningObjectType;
        this.userId = userId;
        this.remoteUserId = remoteUserId;
        this.courseId = courseId;
        this.remoteCourseId = remoteCourseId;
    }
    
    public Assignment() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ID associated with this assignment
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectId() {
        return learningObjectId;
    }

    /**
     * Provider's unique identifier of the learning object related to the assignment
     */
    @JsonIgnore
    public JsonNullable<String> remoteLearningObjectId() {
        return remoteLearningObjectId;
    }

    /**
     * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectExternalReference() {
        return learningObjectExternalReference;
    }

    /**
     * The progress associated with this assigment
     */
    @JsonIgnore
    public JsonNullable<Double> progress() {
        return progress;
    }

    /**
     * The date the assignment was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The date the assignment was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The date the assignment is due to be completed
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> dueDate() {
        return dueDate;
    }

    /**
     * The status of the assignment
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AssignmentStatus> status() {
        return (JsonNullable<AssignmentStatus>) status;
    }

    /**
     * The learning object type of the assignment
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LearningObjectType> learningObjectType() {
        return (JsonNullable<LearningObjectType>) learningObjectType;
    }

    /**
     * The user ID associated with this assignment
     */
    @JsonIgnore
    public JsonNullable<String> userId() {
        return userId;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    @JsonIgnore
    public JsonNullable<String> remoteUserId() {
        return remoteUserId;
    }

    /**
     * The course ID associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> courseId() {
        return courseId;
    }

    /**
     * Provider's unique identifier of the course related to the assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> remoteCourseId() {
        return remoteCourseId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The ID associated with this assignment
     */
    public Assignment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The ID associated with this assignment
     */
    public Assignment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Assignment withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Assignment withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Assignment withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Assignment withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
     */
    public Assignment withLearningObjectId(String learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = JsonNullable.of(learningObjectId);
        return this;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
     */
    public Assignment withLearningObjectId(JsonNullable<String> learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = learningObjectId;
        return this;
    }

    /**
     * Provider's unique identifier of the learning object related to the assignment
     */
    public Assignment withRemoteLearningObjectId(String remoteLearningObjectId) {
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        this.remoteLearningObjectId = JsonNullable.of(remoteLearningObjectId);
        return this;
    }

    /**
     * Provider's unique identifier of the learning object related to the assignment
     */
    public Assignment withRemoteLearningObjectId(JsonNullable<String> remoteLearningObjectId) {
        Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
        this.remoteLearningObjectId = remoteLearningObjectId;
        return this;
    }

    /**
     * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
     */
    public Assignment withLearningObjectExternalReference(String learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
        return this;
    }

    /**
     * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
     */
    public Assignment withLearningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = learningObjectExternalReference;
        return this;
    }

    /**
     * The progress associated with this assigment
     */
    public Assignment withProgress(double progress) {
        Utils.checkNotNull(progress, "progress");
        this.progress = JsonNullable.of(progress);
        return this;
    }

    /**
     * The progress associated with this assigment
     */
    public Assignment withProgress(JsonNullable<Double> progress) {
        Utils.checkNotNull(progress, "progress");
        this.progress = progress;
        return this;
    }

    /**
     * The date the assignment was last updated
     */
    public Assignment withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date the assignment was last updated
     */
    public Assignment withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The date the assignment was created
     */
    public Assignment withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date the assignment was created
     */
    public Assignment withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The date the assignment is due to be completed
     */
    public Assignment withDueDate(OffsetDateTime dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = JsonNullable.of(dueDate);
        return this;
    }

    /**
     * The date the assignment is due to be completed
     */
    public Assignment withDueDate(JsonNullable<OffsetDateTime> dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = dueDate;
        return this;
    }

    /**
     * The status of the assignment
     */
    public Assignment withStatus(AssignmentStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the assignment
     */
    public Assignment withStatus(JsonNullable<? extends AssignmentStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The learning object type of the assignment
     */
    public Assignment withLearningObjectType(LearningObjectType learningObjectType) {
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        this.learningObjectType = JsonNullable.of(learningObjectType);
        return this;
    }

    /**
     * The learning object type of the assignment
     */
    public Assignment withLearningObjectType(JsonNullable<? extends LearningObjectType> learningObjectType) {
        Utils.checkNotNull(learningObjectType, "learningObjectType");
        this.learningObjectType = learningObjectType;
        return this;
    }

    /**
     * The user ID associated with this assignment
     */
    public Assignment withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = JsonNullable.of(userId);
        return this;
    }

    /**
     * The user ID associated with this assignment
     */
    public Assignment withUserId(JsonNullable<String> userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    public Assignment withRemoteUserId(String remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = JsonNullable.of(remoteUserId);
        return this;
    }

    /**
     * Provider's unique identifier of the user related to the assignment
     */
    public Assignment withRemoteUserId(JsonNullable<String> remoteUserId) {
        Utils.checkNotNull(remoteUserId, "remoteUserId");
        this.remoteUserId = remoteUserId;
        return this;
    }

    /**
     * The course ID associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withCourseId(String courseId) {
        Utils.checkNotNull(courseId, "courseId");
        this.courseId = JsonNullable.of(courseId);
        return this;
    }

    /**
     * The course ID associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withCourseId(JsonNullable<String> courseId) {
        Utils.checkNotNull(courseId, "courseId");
        this.courseId = courseId;
        return this;
    }

    /**
     * Provider's unique identifier of the course related to the assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withRemoteCourseId(String remoteCourseId) {
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.remoteCourseId = JsonNullable.of(remoteCourseId);
        return this;
    }

    /**
     * Provider's unique identifier of the course related to the assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Assignment withRemoteCourseId(JsonNullable<String> remoteCourseId) {
        Utils.checkNotNull(remoteCourseId, "remoteCourseId");
        this.remoteCourseId = remoteCourseId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Assignment other = (Assignment) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference) &&
            Utils.enhancedDeepEquals(this.learningObjectId, other.learningObjectId) &&
            Utils.enhancedDeepEquals(this.remoteLearningObjectId, other.remoteLearningObjectId) &&
            Utils.enhancedDeepEquals(this.learningObjectExternalReference, other.learningObjectExternalReference) &&
            Utils.enhancedDeepEquals(this.progress, other.progress) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.dueDate, other.dueDate) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.learningObjectType, other.learningObjectType) &&
            Utils.enhancedDeepEquals(this.userId, other.userId) &&
            Utils.enhancedDeepEquals(this.remoteUserId, other.remoteUserId) &&
            Utils.enhancedDeepEquals(this.courseId, other.courseId) &&
            Utils.enhancedDeepEquals(this.remoteCourseId, other.remoteCourseId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, unifiedCustomFields,
            externalReference, learningObjectId, remoteLearningObjectId,
            learningObjectExternalReference, progress, updatedAt,
            createdAt, dueDate, status,
            learningObjectType, userId, remoteUserId,
            courseId, remoteCourseId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Assignment.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "externalReference", externalReference,
                "learningObjectId", learningObjectId,
                "remoteLearningObjectId", remoteLearningObjectId,
                "learningObjectExternalReference", learningObjectExternalReference,
                "progress", progress,
                "updatedAt", updatedAt,
                "createdAt", createdAt,
                "dueDate", dueDate,
                "status", status,
                "learningObjectType", learningObjectType,
                "userId", userId,
                "remoteUserId", remoteUserId,
                "courseId", courseId,
                "remoteCourseId", remoteCourseId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> externalReference = JsonNullable.undefined();

        private JsonNullable<String> learningObjectId = JsonNullable.undefined();

        private JsonNullable<String> remoteLearningObjectId = JsonNullable.undefined();

        private JsonNullable<String> learningObjectExternalReference = JsonNullable.undefined();

        private JsonNullable<Double> progress = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> dueDate = JsonNullable.undefined();

        private JsonNullable<? extends AssignmentStatus> status = JsonNullable.undefined();

        private JsonNullable<? extends LearningObjectType> learningObjectType = JsonNullable.undefined();

        private JsonNullable<String> userId = JsonNullable.undefined();

        private JsonNullable<String> remoteUserId = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> courseId = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> remoteCourseId = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The ID associated with this assignment
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The ID associated with this assignment
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * The external reference associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external reference associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }


        /**
         * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(String learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = JsonNullable.of(learningObjectId);
            return this;
        }

        /**
         * The learning_object_id associated with this assignment. This is not required unless specified in an integration.
         */
        public Builder learningObjectId(JsonNullable<String> learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = learningObjectId;
            return this;
        }


        /**
         * Provider's unique identifier of the learning object related to the assignment
         */
        public Builder remoteLearningObjectId(String remoteLearningObjectId) {
            Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
            this.remoteLearningObjectId = JsonNullable.of(remoteLearningObjectId);
            return this;
        }

        /**
         * Provider's unique identifier of the learning object related to the assignment
         */
        public Builder remoteLearningObjectId(JsonNullable<String> remoteLearningObjectId) {
            Utils.checkNotNull(remoteLearningObjectId, "remoteLearningObjectId");
            this.remoteLearningObjectId = remoteLearningObjectId;
            return this;
        }


        /**
         * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
         */
        public Builder learningObjectExternalReference(String learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = JsonNullable.of(learningObjectExternalReference);
            return this;
        }

        /**
         * The external reference of the learning object associated with this assignment, this is the main identifier for creating assignments.
         */
        public Builder learningObjectExternalReference(JsonNullable<String> learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = learningObjectExternalReference;
            return this;
        }


        /**
         * The progress associated with this assigment
         */
        public Builder progress(double progress) {
            Utils.checkNotNull(progress, "progress");
            this.progress = JsonNullable.of(progress);
            return this;
        }

        /**
         * The progress associated with this assigment
         */
        public Builder progress(JsonNullable<Double> progress) {
            Utils.checkNotNull(progress, "progress");
            this.progress = progress;
            return this;
        }


        /**
         * The date the assignment was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date the assignment was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * The date the assignment was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date the assignment was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The date the assignment is due to be completed
         */
        public Builder dueDate(OffsetDateTime dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = JsonNullable.of(dueDate);
            return this;
        }

        /**
         * The date the assignment is due to be completed
         */
        public Builder dueDate(JsonNullable<OffsetDateTime> dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = dueDate;
            return this;
        }


        /**
         * The status of the assignment
         */
        public Builder status(AssignmentStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the assignment
         */
        public Builder status(JsonNullable<? extends AssignmentStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The learning object type of the assignment
         */
        public Builder learningObjectType(LearningObjectType learningObjectType) {
            Utils.checkNotNull(learningObjectType, "learningObjectType");
            this.learningObjectType = JsonNullable.of(learningObjectType);
            return this;
        }

        /**
         * The learning object type of the assignment
         */
        public Builder learningObjectType(JsonNullable<? extends LearningObjectType> learningObjectType) {
            Utils.checkNotNull(learningObjectType, "learningObjectType");
            this.learningObjectType = learningObjectType;
            return this;
        }


        /**
         * The user ID associated with this assignment
         */
        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = JsonNullable.of(userId);
            return this;
        }

        /**
         * The user ID associated with this assignment
         */
        public Builder userId(JsonNullable<String> userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }


        /**
         * Provider's unique identifier of the user related to the assignment
         */
        public Builder remoteUserId(String remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = JsonNullable.of(remoteUserId);
            return this;
        }

        /**
         * Provider's unique identifier of the user related to the assignment
         */
        public Builder remoteUserId(JsonNullable<String> remoteUserId) {
            Utils.checkNotNull(remoteUserId, "remoteUserId");
            this.remoteUserId = remoteUserId;
            return this;
        }


        /**
         * The course ID associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder courseId(String courseId) {
            Utils.checkNotNull(courseId, "courseId");
            this.courseId = JsonNullable.of(courseId);
            return this;
        }

        /**
         * The course ID associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder courseId(JsonNullable<String> courseId) {
            Utils.checkNotNull(courseId, "courseId");
            this.courseId = courseId;
            return this;
        }


        /**
         * Provider's unique identifier of the course related to the assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteCourseId(String remoteCourseId) {
            Utils.checkNotNull(remoteCourseId, "remoteCourseId");
            this.remoteCourseId = JsonNullable.of(remoteCourseId);
            return this;
        }

        /**
         * Provider's unique identifier of the course related to the assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder remoteCourseId(JsonNullable<String> remoteCourseId) {
            Utils.checkNotNull(remoteCourseId, "remoteCourseId");
            this.remoteCourseId = remoteCourseId;
            return this;
        }

        public Assignment build() {

            return new Assignment(
                id, remoteId, unifiedCustomFields,
                externalReference, learningObjectId, remoteLearningObjectId,
                learningObjectExternalReference, progress, updatedAt,
                createdAt, dueDate, status,
                learningObjectType, userId, remoteUserId,
                courseId, remoteCourseId);
        }

    }
}
