/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AtsListJobsQueryParamFilter
 * 
 * <p>ATS Jobs filters
 */
public class AtsListJobsQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Use a string with a date to only select results created after that given date
     */
    @SpeakeasyMetadata("queryParam:name=created_after")
    private JsonNullable<OffsetDateTime> createdAfter;

    /**
     * The status of the job
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @SpeakeasyMetadata("queryParam:name=status")
    @Deprecated
    private JsonNullable<? extends AtsListJobsQueryParamStatus> status;

    /**
     * The job_status of the job
     */
    @SpeakeasyMetadata("queryParam:name=job_status")
    private JsonNullable<? extends JobStatus> jobStatus;

    @JsonCreator
    public AtsListJobsQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<OffsetDateTime> createdAfter,
            JsonNullable<? extends AtsListJobsQueryParamStatus> status,
            JsonNullable<? extends JobStatus> jobStatus) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(createdAfter, "createdAfter");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(jobStatus, "jobStatus");
        this.updatedAfter = updatedAfter;
        this.createdAfter = createdAfter;
        this.status = status;
        this.jobStatus = jobStatus;
    }
    
    public AtsListJobsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAfter() {
        return createdAfter;
    }

    /**
     * The status of the job
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsListJobsQueryParamStatus> status() {
        return (JsonNullable<AtsListJobsQueryParamStatus>) status;
    }

    /**
     * The job_status of the job
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobStatus> jobStatus() {
        return (JsonNullable<JobStatus>) jobStatus;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListJobsQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListJobsQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListJobsQueryParamFilter withCreatedAfter(OffsetDateTime createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = JsonNullable.of(createdAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListJobsQueryParamFilter withCreatedAfter(JsonNullable<OffsetDateTime> createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = createdAfter;
        return this;
    }

    /**
     * The status of the job
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsListJobsQueryParamFilter withStatus(AtsListJobsQueryParamStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the job
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public AtsListJobsQueryParamFilter withStatus(JsonNullable<? extends AtsListJobsQueryParamStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The job_status of the job
     */
    public AtsListJobsQueryParamFilter withJobStatus(JobStatus jobStatus) {
        Utils.checkNotNull(jobStatus, "jobStatus");
        this.jobStatus = JsonNullable.of(jobStatus);
        return this;
    }

    /**
     * The job_status of the job
     */
    public AtsListJobsQueryParamFilter withJobStatus(JsonNullable<? extends JobStatus> jobStatus) {
        Utils.checkNotNull(jobStatus, "jobStatus");
        this.jobStatus = jobStatus;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsListJobsQueryParamFilter other = (AtsListJobsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.createdAfter, other.createdAfter) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.jobStatus, other.jobStatus);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, createdAfter, status,
            jobStatus);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsListJobsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "createdAfter", createdAfter,
                "status", status,
                "jobStatus", jobStatus);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAfter = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends AtsListJobsQueryParamStatus> status = JsonNullable.undefined();

        private JsonNullable<? extends JobStatus> jobStatus = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(OffsetDateTime createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = JsonNullable.of(createdAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(JsonNullable<OffsetDateTime> createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = createdAfter;
            return this;
        }


        /**
         * The status of the job
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder status(AtsListJobsQueryParamStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the job
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder status(JsonNullable<? extends AtsListJobsQueryParamStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The job_status of the job
         */
        public Builder jobStatus(JobStatus jobStatus) {
            Utils.checkNotNull(jobStatus, "jobStatus");
            this.jobStatus = JsonNullable.of(jobStatus);
            return this;
        }

        /**
         * The job_status of the job
         */
        public Builder jobStatus(JsonNullable<? extends JobStatus> jobStatus) {
            Utils.checkNotNull(jobStatus, "jobStatus");
            this.jobStatus = jobStatus;
            return this;
        }

        public AtsListJobsQueryParamFilter build() {

            return new AtsListJobsQueryParamFilter(
                updatedAfter, createdAfter, status,
                jobStatus);
        }

    }
}
