/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneListConnectorsMeta;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneListConnectorsMetaRequestBuilder {
    private JsonNullable<String> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneListConnectorsMetaRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListConnectorsMetaRequestBuilder include(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)include);
        return this;
    }

    public StackoneListConnectorsMetaRequestBuilder include(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public StackoneListConnectorsMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListConnectorsMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneListConnectorsMetaRequest buildRequest() {
        StackoneListConnectorsMetaRequest request = new StackoneListConnectorsMetaRequest(this.include);
        return request;
    }

    public StackoneListConnectorsMetaResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneListConnectorsMeta.Sync operation = new StackoneListConnectorsMeta.Sync(this.sdkConfiguration, options);
        StackoneListConnectorsMetaRequest request = this.buildRequest();
        return (StackoneListConnectorsMetaResponse)operation.handleResponse(operation.doRequest(request));
    }
}

