package com.stackspot.plugin

import com.stackspot.plugin.openapi.GenerateOpenApiTask
import com.stackspot.plugin.openapi.GenerateOpenApiTaskConfigurator
import org.gradle.api.Plugin
import org.gradle.api.Project

class OpenApiPlugin : Plugin<Project> {

    override fun apply(project: Project) {

        val openApiConfig =
            project.extensions.create("generateOpenApi", GenerateOpenApiTaskConfigurator::class.java, project)

        project.tasks.register("generateOpenApi", GenerateOpenApiTask::class.java) { openApiTask ->
            openApiTask.framework.set(openApiConfig.framework)
            openApiTask.inputDir.set(openApiConfig.inputDir)
            openApiTask.outputDir.set(openApiConfig.outputDir)
            openApiTask.packageName.set(openApiConfig.packageName)
        }
    }

    val org.gradle.api.Project.`kotlin`: org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension
        get() =
            (this as org.gradle.api.plugins.ExtensionAware).extensions.getByName("kotlin") as org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension
}
