package com.stackspot.plugin.openapi

import org.gradle.api.Project
import org.gradle.api.file.DirectoryProperty
import org.gradle.api.model.ObjectFactory
import org.gradle.api.provider.Property
import javax.inject.Inject

open class GenerateOpenApiTaskConfigurator @Inject constructor(project: Project) {

    enum class Framework {
        MICRONAUT, SPRING
    }

    private val objects: ObjectFactory = project.objects

    val framework: Property<Framework> = objects.property(Framework::class.java).convention(Framework.SPRING)
    val inputDir: Property<String> = objects.property(String::class.java).convention("src/main/openapi")
    val outputDir: DirectoryProperty =
        objects.directoryProperty().convention(project.layout.buildDirectory.dir("generated/source/openapi").get())
    val packageName: Property<String> = objects.property(String::class.java).convention("gen")
}
