/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.cache;

import com.strategicgains.restexpress.Request;
import com.strategicgains.restexpress.Response;
import com.strategicgains.restexpress.pipeline.Postprocessor;
import com.strategicgains.util.date.DateAdapter;
import com.strategicgains.util.date.HttpHeaderTimestampAdapter;
import java.util.Date;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class CacheHeaderPostprocessor
implements Postprocessor {
    private static final String NO_CACHE = "no-cache";
    DateAdapter fmt = new HttpHeaderTimestampAdapter();

    public void process(Request request, Response response) {
        if (!request.isMethodGet() && !HttpMethod.HEAD.equals((Object)request.getHttpMethod())) {
            return;
        }
        Object maxAge = request.getParameter("max.age");
        if (maxAge != null) {
            response.addHeader("Cache-Control", String.format("max-age=%s", maxAge));
            response.addHeader("Expires", this.fmt.format(this.computeExpiresDate((Integer)maxAge)));
        } else if (request.isFlagged("no.caching")) {
            response.addHeader("Cache-Control", NO_CACHE);
            response.addHeader("Pragma", NO_CACHE);
        }
    }

    private Date computeExpiresDate(Integer maxAge) {
        long millis = System.currentTimeMillis() + (long)maxAge.intValue() * 1000L;
        return new Date(millis);
    }
}

